/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal;

import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;
import org.picketlink.Identity;
import org.picketlink.annotations.PicketLink;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.http.internal.PicketLinkHttpServletRequest;
import org.picketlink.idm.PartitionManager;
import org.picketlink.internal.el.ELProcessor;

@WebListener
public class HttpServletRequestListener
implements ServletRequestListener {
    private static ThreadLocal<HttpServletRequest> SERVLET_REQUEST = new ThreadLocal();
    @Inject
    private Instance<Identity> identityInstance;
    @Inject
    private Instance<DefaultLoginCredentials> credentialsInstance;
    @Inject
    private Instance<PartitionManager> partitionManager;
    @Inject
    private ELProcessor elProcessor;

    public void requestInitialized(ServletRequestEvent sre) {
        SERVLET_REQUEST.set((HttpServletRequest)sre.getServletRequest());
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        SERVLET_REQUEST.remove();
    }

    @PicketLink
    @Produces
    @Typed(value={HttpServletRequest.class})
    public HttpServletRequest produce() {
        HttpServletRequest request = SERVLET_REQUEST.get();
        if (request != null) {
            return new PicketLinkHttpServletRequest(request, this.resolveInstance(this.identityInstance), this.resolveInstance(this.credentialsInstance), (PartitionManager)this.partitionManager.get(), this.elProcessor);
        }
        return null;
    }

    private <I> I resolveInstance(Instance<I> instance) {
        if (instance.isUnsatisfied()) {
            throw new IllegalStateException("Instance [" + instance + "] not found.");
        }
        if (instance.isAmbiguous()) {
            throw new IllegalStateException("Instance [" + instance + "] is ambiguous.");
        }
        try {
            return (I)instance.get();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not retrieve instance [" + instance + "].", e);
        }
    }
}

