/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotData;

public class ClasspathSnapshot {
    private final LinkedHashMap<File, ClasspathEntrySnapshot> entrySnapshots;
    private final ClasspathSnapshotData data;

    public ClasspathSnapshot(LinkedHashMap<File, ClasspathEntrySnapshot> entrySnapshots, ClasspathSnapshotData data) {
        this.entrySnapshots = entrySnapshots;
        this.data = data;
    }

    public ClasspathEntrySnapshot getSnapshot(File file) {
        return this.entrySnapshots.get(file);
    }

    public Set<File> getEntries() {
        return this.entrySnapshots.keySet();
    }

    public boolean isAnyClassDuplicated(Set<String> classNames) {
        boolean noCommonElements = Collections.disjoint(this.data.getDuplicateClasses(), classNames);
        return !noCommonElements;
    }

    public ClasspathSnapshotData getData() {
        return this.data;
    }

    public boolean isAnyClassDuplicated(File classpathEntry) {
        ClasspathEntrySnapshot snapshot = this.getSnapshot(classpathEntry);
        return this.isAnyClassDuplicated(snapshot.getClasses());
    }
}

