/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"
#include"matrix.h"
/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: polyeder_to_vecs.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/


/**************************************************************************\
@---------------------------------------------------------------------------
@ matrix_TYP **polyeder_to_vecs(P)
@ polyeder_TYP *P;
@
@ polyeder_to_vecs calculates two matrices X[0] and X[1]
@ where the rows of X[0] contain the coordinates of the vertices
@ i.e. X[0]->array.SZ[i] = P->vert[i]->v
@ and the rows of X[1] contain the coordinates of the walls
@ i.e. X[1]->array.SZ[i] = P->wall[i]->gl.
@---------------------------------------------------------------------------
@
\**************************************************************************/
matrix_TYP **polyeder_to_vecs(P)
polyeder_TYP *P;
{
  int i,j, dim;
  matrix_TYP **M;

  if( (M = (matrix_TYP **)malloc(2 *sizeof(matrix_TYP *))) == NULL)
  {
    printf("malloc of 'M' in 'polyeder_to_vecs' failed\n");
    exit(2);
  }
  dim = P->vert[0]->dim;
  M[0] = init_mat(P->vert_no, dim, "");
  M[1] = init_mat(P->wall_no, dim, "");
  for(i=0;i<P->vert_no;i++)
    for(j=0;j<dim;j++)
      M[0]->array.SZ[i][j] = P->vert[i]->v[j];
  for(i=0;i<P->wall_no;i++)
    for(j=0;j<dim;j++)
      M[1]->array.SZ[i][j] = P->wall[i]->gl[j];
  return(M);
}
