/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.time;

import accessories.plugins.time.TimeList;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class FlatNodeTableFilterModel
extends AbstractTableModel {
    private final TableModel mTableModel;
    private String mFilterRegexp;
    private ArrayList mIndexArray;
    private Pattern mPattern;
    private final int mNodeTextColumn;
    private int mNoteTextColumn;

    public FlatNodeTableFilterModel(TableModel tableModel, int node_text_column, int note_text_column) {
        this.mTableModel = tableModel;
        this.mNodeTextColumn = node_text_column;
        this.mNoteTextColumn = note_text_column;
        tableModel.addTableModelListener(new TableModelHandler());
        this.resetFilter();
    }

    public void resetFilter() {
        this.setFilter(".*");
    }

    public void setFilter(String filterRegexp) {
        this.mFilterRegexp = filterRegexp;
        this.mPattern = Pattern.compile(this.mFilterRegexp, 2);
        this.updateIndexArray();
        this.fireTableDataChanged();
    }

    private void updateIndexArray() {
        ArrayList<Integer> newIndexArray = new ArrayList<Integer>();
        for (int i = 0; i < this.mTableModel.getRowCount(); ++i) {
            TimeList.NodeHolder nodeContent = (TimeList.NodeHolder)this.mTableModel.getValueAt(i, this.mNodeTextColumn);
            if (this.mPattern.matcher(nodeContent.toString()).matches()) {
                newIndexArray.add(new Integer(i));
                continue;
            }
            TimeList.NotesHolder noteContent = (TimeList.NotesHolder)this.mTableModel.getValueAt(i, this.mNoteTextColumn);
            if (!this.mPattern.matcher(noteContent.toString()).matches()) continue;
            newIndexArray.add(new Integer(i));
        }
        this.mIndexArray = newIndexArray;
    }

    @Override
    public int getRowCount() {
        return this.mIndexArray.size();
    }

    @Override
    public int getColumnCount() {
        return this.mTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int pColumnIndex) {
        return this.mTableModel.getColumnName(pColumnIndex);
    }

    public Class getColumnClass(int arg0) {
        return this.mTableModel.getColumnClass(arg0);
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            throw new IllegalArgumentException("Illegal Row specified: " + row);
        }
        int origRow = (Integer)this.mIndexArray.get(row);
        return this.mTableModel.getValueAt(origRow, column);
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent arg0) {
            FlatNodeTableFilterModel.this.fireTableDataChanged();
        }
    }
}

