/*
 * Decompiled with CFR 0.152.
 */
package esmska.integration.mac;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEventListener;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eio.FileManager;
import esmska.Context;
import esmska.gui.MainFrame;
import esmska.gui.NotificationIcon;
import esmska.gui.ThemeManager;
import esmska.integration.ActionBean;
import esmska.integration.IntegrationAdapter;
import esmska.integration.mac.ModalSheetCounter;
import esmska.integration.mac.UnifiedToolbarSupport;
import esmska.integration.mac.handler.MacAboutHandler;
import esmska.integration.mac.handler.MacAppReOpenedListener;
import esmska.integration.mac.handler.MacOpenFilesHandler;
import esmska.integration.mac.handler.MacPreferencesHandler;
import esmska.integration.mac.handler.MacQuitHandler;
import esmska.integration.mac.handler.MacSystemSleepListener;
import esmska.integration.mac.handler.MacUserSessionListener;
import esmska.utils.RuntimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.PopupMenu;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class MacIntegration
extends IntegrationAdapter {
    private static final Logger logger = Logger.getLogger(MacIntegration.class.getName());
    private static final String PROGRAM_DIRNAME = "Esmska";
    private static final String LOG_FILENAME = "Esmska.log";
    private static final Color LEOPARD_PANEL_COLOR = new Color(232, 232, 232);
    private ModalSheetCounter modalSheetCounter;

    @Override
    protected void initialize() {
        super.initialize();
        this.modalSheetCounter = new ModalSheetCounter();
    }

    @Override
    public void activateGUI() {
        this.addEventHandlers();
        this.setupAqua();
    }

    private void addEventHandlers() {
        Application app = Application.getApplication();
        app.setAboutHandler((AboutHandler)new MacAboutHandler(this.bean));
        app.setPreferencesHandler((PreferencesHandler)new MacPreferencesHandler(this.bean));
        app.setOpenFileHandler((OpenFilesHandler)new MacOpenFilesHandler());
        app.setQuitHandler((QuitHandler)new MacQuitHandler(this.bean));
        app.addAppEventListener((AppEventListener)new MacAppReOpenedListener());
        app.addAppEventListener((AppEventListener)new MacUserSessionListener());
        app.addAppEventListener((AppEventListener)new MacSystemSleepListener());
        if (RuntimeUtils.isAppleJava()) {
            app.setDefaultMenuBar(Context.mainFrame.getJMenuBar());
        }
    }

    private void setupAqua() {
        if (!ThemeManager.isAquaCurrentLaF()) {
            return;
        }
        MainFrame frame = Context.mainFrame;
        JMenuBar bar = frame.getJMenuBar();
        for (Component menu : bar.getComponents()) {
            JMenu m = (JMenu)menu;
            m.setMnemonic(-1);
            m.setToolTipText(null);
            for (Component c : m.getPopupMenu().getComponents()) {
                if (!(c instanceof JMenuItem)) continue;
                JMenuItem i = (JMenuItem)c;
                i.setIcon(null);
                i.setMnemonic(-1);
                i.setToolTipText(null);
            }
        }
        UnifiedToolbarSupport.installSupport();
        MacIntegration.setBackgroundForPanelsRecursively(frame);
        frame.getStatusPanel().setBorder(BorderFactory.createEmptyBorder(0, 2, 4, 2));
    }

    private static void setBackgroundForPanelsRecursively(JFrame frame) {
        Container contentPane = frame.getContentPane();
        contentPane.setBackground(LEOPARD_PANEL_COLOR);
        MacIntegration.changeBackgroundRecursively(contentPane);
    }

    private static void changeBackgroundRecursively(Component rootComponent) {
        if (rootComponent instanceof JToolBar) {
            return;
        }
        if (rootComponent instanceof JPanel || rootComponent instanceof JSplitPane) {
            Component[] components;
            Container container = (Container)rootComponent;
            container.setBackground(LEOPARD_PANEL_COLOR);
            for (Component c : components = container.getComponents()) {
                MacIntegration.changeBackgroundRecursively(c);
            }
        }
    }

    @Override
    public File getConfigDir(File defaultConfigDir) {
        return this.getDataDir(defaultConfigDir);
    }

    @Override
    public File getDataDir(File defaultDataDir) {
        try {
            return new File(FileManager.findFolder((short)-32763, (int)FileManager.OSTypeToInt((String)"asup")));
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Could not find directory for data files", ex);
            return new File(System.getProperty("user.home") + "/Library/Application Support");
        }
    }

    @Override
    public File getGatewayDir(File defaultDir) {
        try {
            String gatewaysURL = FileManager.getResource((String)"gateways");
            return new File(gatewaysURL);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Could not find gateways directory inside Mac bundle.", ex);
            return super.getGatewayDir(defaultDir);
        }
    }

    @Override
    public File getLogFile(File defaultLogFile) {
        String dir;
        try {
            dir = FileManager.findFolder((short)-32763, (int)FileManager.OSTypeToInt((String)"logs"));
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Could not find directory for log files", ex);
            dir = System.getProperty("user.home") + "/Library/Logs";
        }
        return new File(dir, LOG_FILENAME);
    }

    @Override
    public String getProgramDirName(String defaultProgramDirName) {
        return PROGRAM_DIRNAME;
    }

    @Override
    public void setActionBean(ActionBean bean) {
        NotificationIcon icon;
        super.setActionBean(bean);
        if (RuntimeUtils.isAppleJava() && (icon = NotificationIcon.getInstance()) != null) {
            PopupMenu menu = icon.getPopup();
            Application.getApplication().setDockMenu(menu);
        }
    }

    @Override
    public void registerModalSheet(JDialog dialog) {
        dialog.removeWindowListener(this.modalSheetCounter);
        dialog.addWindowListener(this.modalSheetCounter);
    }

    @Override
    public boolean isModalSheetVisible() {
        return this.modalSheetCounter.isModalSheetVisible();
    }

    @Override
    public void setSMSCount(Integer count) {
        if (count == null || count <= 0) {
            Application.getApplication().setDockIconBadge(null);
        } else {
            Application.getApplication().setDockIconBadge(count.toString());
        }
    }
}

