/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StatusInfo;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

class TypedElementSelectionValidator
implements ISelectionStatusValidator {
    private IStatus _fgErrorStatus = new StatusInfo(4, "");
    private IStatus _fgOKStatus = new StatusInfo();
    private Class[] _fAcceptedTypes;
    private boolean _fAllowMultipleSelection;
    private Collection _fRejectedElements;

    public TypedElementSelectionValidator(Class[] acceptedTypes, boolean allowMultipleSelection) {
        this(acceptedTypes, allowMultipleSelection, null);
    }

    public TypedElementSelectionValidator(Class[] acceptedTypes, boolean allowMultipleSelection, Collection rejectedElements) {
        Assert.isNotNull((Object)acceptedTypes);
        this._fAcceptedTypes = acceptedTypes;
        this._fAllowMultipleSelection = allowMultipleSelection;
        this._fRejectedElements = rejectedElements;
    }

    public IStatus validate(Object[] elements) {
        if (this.isValid(elements)) {
            return this._fgOKStatus;
        }
        return this._fgErrorStatus;
    }

    private boolean isOfAcceptedType(Object o) {
        int i = 0;
        while (i < this._fAcceptedTypes.length) {
            if (this._fAcceptedTypes[i].isInstance(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isRejectedElement(Object elem) {
        return this._fRejectedElements != null && this._fRejectedElements.contains(elem);
    }

    private boolean isValid(Object[] selection) {
        if (selection.length == 0) {
            return false;
        }
        if (!this._fAllowMultipleSelection && selection.length != 1) {
            return false;
        }
        int i = 0;
        while (i < selection.length) {
            Object o = selection[i];
            if (!this.isOfAcceptedType(o) || this.isRejectedElement(o)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

