/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.CommandResources;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataTableInsertColumnHeaderCommand
extends DesignerCommand {
    boolean _header;
    private Element _dataTable;

    public DataTableInsertColumnHeaderCommand(IHTMLGraphicalViewer viewer, Element dataTable, boolean header) {
        super(header ? CommandResources.getString("DataTableInsertColumnHeaderCommand.Label.InsertHeader") : CommandResources.getString("DataTableInsertColumnHeaderCommand.Label.InsertFooter"), viewer);
        this._header = header;
        this._dataTable = dataTable;
    }

    public boolean canExecute() {
        int num = 0;
        NodeList children = this._dataTable.getChildNodes();
        int i = 0;
        int size = children.getLength();
        while (i < size) {
            Element column;
            Node node = children.item(i);
            if (JSFDOMUtil.isHColumn(node) && !this.hasHeader(column = (Element)node)) {
                ++num;
                break;
            }
            ++i;
        }
        if (num == 0) {
            return false;
        }
        return super.canExecute();
    }

    protected void doExecute() {
        String type = this._header ? "header" : "footer";
        NodeList children = this._dataTable.getChildNodes();
        int i = 0;
        int size = children.getLength();
        while (i < size) {
            Element column;
            Node node = children.item(i);
            if (JSFDOMUtil.isHColumn(node) && !this.hasHeader(column = (Element)node)) {
                Element headerOrFooter = this.createHeaderOrFooter(type);
                column.appendChild(headerOrFooter);
            }
            ++i;
        }
        this.formatNode(this._dataTable);
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._dataTable);
    }

    private boolean hasHeader(Element column) {
        return JSFDOMUtil.findFacet(column, this._header ? "header" : "footer") != null;
    }

    private Element createHeaderOrFooter(String type) {
        Element facet = this.createFacet();
        Element def = this.createDefaultElement();
        facet.appendChild(def);
        facet.setAttribute("name", type);
        return facet;
    }

    private Element createFacet() {
        String prefix = JSPUtil.getOrCreatePrefix((IDOMModel)this.getModel(), (String)"http://java.sun.com/jsf/core", (String)"f");
        Element ele = this._dataTable.getOwnerDocument().createElement("facet");
        ele.setPrefix(prefix);
        return ele;
    }

    private Element createDefaultElement() {
        String prefix = JSPUtil.getOrCreatePrefix((IDOMModel)this.getModel(), (String)"http://java.sun.com/jsf/html", (String)"h");
        Element ele = this._dataTable.getOwnerDocument().createElement("outputText");
        ele.setPrefix(prefix);
        if (this._header) {
            ele.setAttribute("value", "Column Header");
        } else {
            ele.setAttribute("value", "Column Footer");
        }
        return ele;
    }
}

