/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11;

import com.ibm.wsdl.DefinitionImpl;
import com.ibm.wsdl.util.StringUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.wsdl.Import;
import javax.wsdl.WSDLException;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ImportHolder;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDLDocument;
import org.eclipse.wst.wsdl.validation.internal.xml.LineNumberDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSDLReaderImpl {
    protected MessageGenerator messagegenerator;
    protected IWSDL11ValidationInfo wsdlvalinfo;

    public WSDLReaderImpl(IWSDL11ValidationInfo wsdlvalinfo) {
        this.wsdlvalinfo = wsdlvalinfo;
    }

    protected WSDLDocument[] parseDocument(String documentBaseURI, Element defEl) throws WSDLException {
        Iterator docsIter;
        WSDLDocument doc;
        ImportHolder imp;
        int initialImportArraySize = 20;
        List<E>[] filesAtDepth = new ArrayList[initialImportArraySize];
        Hashtable filesImporting = new Hashtable();
        TreeSet<ImportHolder> parsedImports = new TreeSet<ImportHolder>();
        TreeSet<ImportHolder> importsToParse = new TreeSet<ImportHolder>();
        int maxdepth = 0;
        WSDLDocument rootdoc = new WSDLDocument(documentBaseURI, defEl, 0, this.messagegenerator, this.wsdlvalinfo);
        String targetNamespace = rootdoc.getDefinition().getTargetNamespace();
        ImportHolder rootImport = new ImportHolder(targetNamespace, documentBaseURI, documentBaseURI, rootdoc, 0, null, this.messagegenerator, this.wsdlvalinfo);
        rootImport.createWSDLImport(rootdoc);
        parsedImports.add(rootImport);
        ArrayList<WSDLDocument> rootList = new ArrayList<WSDLDocument>();
        filesImporting.put(rootImport.getLocation(), new ArrayList());
        rootList.add(rootdoc);
        filesAtDepth[0] = rootList;
        importsToParse.addAll(rootdoc.getImports());
        Set imps = rootdoc.getImports();
        Iterator impIter = imps.iterator();
        while (impIter.hasNext()) {
            imp = (ImportHolder)impIter.next();
            ArrayList<WSDLDocument> tempList = new ArrayList<WSDLDocument>();
            tempList.add(imp.getImportingDocument());
            filesImporting.put(imp.getLocation(), tempList);
        }
        while (!importsToParse.isEmpty()) {
            int impDepth;
            imp = (ImportHolder)importsToParse.first();
            imp.initialize();
            WSDLDocument impDoc = imp.getWSDLDocument();
            importsToParse.remove(imp);
            parsedImports.add(imp);
            if (impDoc == null) continue;
            if (imp.getDepth() >= initialImportArraySize) {
                List[] tempArray = new List[filesAtDepth.length + initialImportArraySize];
                System.arraycopy(filesAtDepth, 0, tempArray, 0, filesAtDepth.length);
                filesAtDepth = tempArray;
            }
            if (filesAtDepth[impDepth = imp.getDepth()] == null) {
                if (maxdepth < impDepth) {
                    maxdepth = impDepth;
                }
                filesAtDepth[impDepth] = new ArrayList();
            }
            filesAtDepth[imp.getDepth()].add(impDoc);
            Set imports = impDoc.getImports();
            ImportHolder[] importsArray = imports.toArray(new ImportHolder[imports.size()]);
            int i = 0;
            while (i < importsArray.length) {
                ImportHolder ih = importsArray[i];
                if (filesImporting.containsKey(ih.getLocation())) {
                    ((List)filesImporting.get(ih.getLocation())).add(ih.getImportingDocument());
                } else {
                    ArrayList<WSDLDocument> tempList = new ArrayList<WSDLDocument>();
                    tempList.add(ih.getImportingDocument());
                    filesImporting.put(ih.getLocation(), tempList);
                    importsToParse.add(ih);
                }
                ++i;
            }
        }
        Iterator importElementsIter = parsedImports.iterator();
        while (importElementsIter.hasNext()) {
            ImportHolder imp2 = (ImportHolder)importElementsIter.next();
            List files = (List)filesImporting.get(imp2.getLocation());
            Iterator filesIter = files.iterator();
            while (filesIter.hasNext()) {
                doc = (WSDLDocument)filesIter.next();
                DefinitionImpl def = (DefinitionImpl)doc.getDefinition();
                Import impElem = imp2.getImport();
                if (impElem == null) continue;
                def.addImport(impElem);
                if (imp2.isWSDLFileImport()) continue;
                doc.addSchemas(imp2.getSchemas());
            }
        }
        int i = maxdepth;
        while (i >= 0) {
            ArrayList docs = filesAtDepth[i];
            docsIter = docs.iterator();
            while (docsIter.hasNext()) {
                doc = (WSDLDocument)docsIter.next();
                doc.parseMessages();
            }
            --i;
        }
        i = maxdepth;
        while (i >= 0) {
            ArrayList docs = filesAtDepth[i];
            docsIter = docs.iterator();
            while (docsIter.hasNext()) {
                doc = (WSDLDocument)docsIter.next();
                doc.parsePorttypes();
            }
            --i;
        }
        i = maxdepth;
        while (i >= 0) {
            ArrayList docs = filesAtDepth[i];
            docsIter = docs.iterator();
            while (docsIter.hasNext()) {
                doc = (WSDLDocument)docsIter.next();
                doc.parseBindings();
            }
            --i;
        }
        i = maxdepth;
        while (i >= 0) {
            ArrayList docs = filesAtDepth[i];
            docsIter = docs.iterator();
            while (docsIter.hasNext()) {
                doc = (WSDLDocument)docsIter.next();
                doc.parseServices();
            }
            --i;
        }
        i = maxdepth;
        while (i >= 0) {
            ArrayList docs = filesAtDepth[i];
            docsIter = docs.iterator();
            while (docsIter.hasNext()) {
                doc = (WSDLDocument)docsIter.next();
                doc.parseExtensibilityElements();
            }
            --i;
        }
        ArrayList<WSDLDocument> wsdlDocs = new ArrayList<WSDLDocument>();
        int i2 = maxdepth;
        while (i2 >= 0) {
            List docs = filesAtDepth[i2];
            Iterator docsIter2 = docs.iterator();
            while (docsIter2.hasNext()) {
                WSDLDocument doc2 = (WSDLDocument)docsIter2.next();
                wsdlDocs.add(doc2);
            }
            --i2;
        }
        return wsdlDocs.toArray(new WSDLDocument[wsdlDocs.size()]);
    }

    public static Document getDocument(InputSource inputSource, String desc) throws WSDLException {
        try {
            StandardParserConfiguration configuration = new StandardParserConfiguration(){

                protected XMLErrorReporter createErrorReporter() {
                    return new XMLErrorReporter(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
                            boolean reportError = true;
                            if (key.equals("PrematureEOF")) {
                                reportError = false;
                            }
                            if (reportError) {
                                super.reportError(domain, key, arguments, severity);
                            }
                        }
                    };
                }
            };
            ErrorHandler errorHandler = new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                }

                public void warning(SAXParseException exception) throws SAXException {
                }
            };
            LineNumberDOMParser builder = new LineNumberDOMParser((XMLParserConfiguration)configuration);
            builder.setErrorHandler(errorHandler);
            builder.parse(inputSource);
            Document doc = builder.getDocument();
            return doc;
        }
        catch (Throwable t) {
            throw new WSDLException("PARSER_ERROR", "Problem parsing '" + desc + "'.", t);
        }
    }

    public WSDLDocument[] readWSDL(String contextURI, String wsdlURI) throws WSDLException {
        try {
            URL contextURL = contextURI != null ? StringUtils.getURL(null, (String)contextURI) : null;
            URL url = StringUtils.getURL((URL)contextURL, (String)wsdlURI);
            InputStream reader = StringUtils.getContentAsInputStream((URL)url);
            InputSource inputSource = new InputSource(reader);
            Document doc = WSDLReaderImpl.getDocument(inputSource, wsdlURI);
            reader.close();
            WSDLDocument[] wsdlDocs = null;
            if (doc.getDocumentElement() != null) {
                wsdlDocs = this.readWSDL(url.toString(), doc);
            }
            return wsdlDocs;
        }
        catch (WSDLException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + wsdlURI + "'.", t);
        }
    }

    public void setMessageGenerator(MessageGenerator mg) {
        this.messagegenerator = mg;
    }

    public WSDLDocument[] readWSDL(String wsdlURI) throws WSDLException {
        return this.readWSDL(null, wsdlURI);
    }

    protected WSDLDocument[] readWSDL(String documentBaseURI, Element definitionsElement) throws WSDLException {
        return this.parseDocument(documentBaseURI, definitionsElement);
    }

    public WSDLDocument[] readWSDL(String documentBaseURI, Document wsdlDocument) throws WSDLException {
        return this.readWSDL(documentBaseURI, wsdlDocument.getDocumentElement());
    }
}

