/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.analyzer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.WSDLException;
import org.eclipse.wst.wsi.internal.WSITestToolsProperties;
import org.eclipse.wst.wsi.internal.core.ToolInfo;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSIFileNotFoundException;
import org.eclipse.wst.wsi.internal.core.analyzer.Analyzer;
import org.eclipse.wst.wsi.internal.core.analyzer.AnalyzerContext;
import org.eclipse.wst.wsi.internal.core.analyzer.ServiceReference;
import org.eclipse.wst.wsi.internal.core.analyzer.config.UDDIReference;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.WSDLElementImpl;
import org.eclipse.wst.wsi.internal.core.document.DocumentWriter;
import org.eclipse.wst.wsi.internal.core.profile.validator.BaseValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.Report;
import org.eclipse.wst.wsi.internal.core.report.ReportArtifact;
import org.eclipse.wst.wsi.internal.core.report.ReportContext;
import org.eclipse.wst.wsi.internal.core.report.ReportWriter;
import org.eclipse.wst.wsi.internal.core.report.impl.DefaultReporter;
import org.eclipse.wst.wsi.internal.core.util.ArtifactType;
import org.eclipse.wst.wsi.internal.core.util.UDDIUtils;
import org.eclipse.wst.wsi.internal.core.util.WSIProperties;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLDocument;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLUtils;
import org.eclipse.wst.wsi.internal.core.xml.XMLDocumentCache;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.BindingDetail;
import org.uddi4j.response.TModelDetail;

public class BasicProfileAnalyzer
extends Analyzer {
    public static final String TOOL_NAME = "Analyzer";
    protected WSDLDocument wsdlDocument = null;

    public BasicProfileAnalyzer(String[] args) throws WSIException {
        super(args, new ToolInfo(TOOL_NAME));
        new XMLDocumentCache();
    }

    public BasicProfileAnalyzer(String[] args, boolean validate) throws WSIException {
        super(args, new ToolInfo(TOOL_NAME), validate);
        new XMLDocumentCache();
    }

    public BasicProfileAnalyzer(List analyzerConfigList) throws WSIException {
        super(analyzerConfigList, new ToolInfo(TOOL_NAME));
        new XMLDocumentCache();
    }

    public BasicProfileAnalyzer(List analyzerConfigList, String wsdlURI) throws WSIException {
        super(analyzerConfigList, new ToolInfo(TOOL_NAME));
        new XMLDocumentCache();
        try {
            if (wsdlURI != null) {
                this.wsdlDocument = new WSDLDocument(wsdlURI);
            }
        }
        catch (WSDLException we) {
            throw new WSIException(we.getMessage(), we);
        }
    }

    private WSDLDocument getWsdlFromUddi() {
        WSDLDocument wsdlDoc = null;
        try {
            UDDIProxy uddiProxy = new UDDIProxy();
            UDDIReference uddiReference = this.getAnalyzerConfig().getUDDIReference();
            uddiProxy.setInquiryURL(uddiReference.getInquiryURL());
            TModel tModel = null;
            if (uddiReference.getKeyType().equals("bindingKey")) {
                BindingDetail bindingDetail = uddiProxy.get_bindingDetail(uddiReference.getKey());
                BindingTemplate bindingTemplate = (BindingTemplate)bindingDetail.getBindingTemplateVector().elementAt(0);
                tModel = UDDIUtils.findTModel(uddiProxy, bindingTemplate, false);
            } else {
                TModelDetail tModelDetail = uddiProxy.get_tModelDetail(uddiReference.getKey());
                tModel = (TModel)tModelDetail.getTModelVector().elementAt(0);
            }
            String overviewURL = UDDIUtils.getOverviewURL(tModel);
            String wsdlURI = UDDIUtils.getWSDLLocation(overviewURL);
            wsdlDoc = new WSDLDocument(wsdlURI);
            if (this.analyzerContext.getServiceReference().getWSDLElement() == null) {
                Binding binding = UDDIUtils.getBinding(overviewURL, wsdlDoc);
                String bindingName = binding == null ? null : binding.getQName().getLocalPart();
                String namespace = binding == null ? null : binding.getQName().getNamespaceURI();
                WSDLElementImpl wsdlElement = new WSDLElementImpl();
                wsdlElement.setName(bindingName);
                wsdlElement.setNamespace(namespace);
                wsdlElement.setType("binding");
                this.analyzerContext.getServiceReference().setWSDLElement(wsdlElement);
            }
            return wsdlDoc;
        }
        catch (Exception exception) {
            return wsdlDoc;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int validateConformance() throws WSIException {
        Report report;
        int statusCode;
        block13: {
            statusCode = 0;
            report = null;
            ReportArtifact reportArtifact = null;
            this.analyzerContext = new AnalyzerContext(new ServiceReference(this.getAnalyzerConfig()));
            DocumentWriter reportWriter = null;
            try {
                try {
                    this.profileAssertions = WSITestToolsProperties.getProfileAssertions(this.getAnalyzerConfig().getTestAssertionsDocumentLocation());
                    if (this.profileAssertions == null) {
                        throw new WSIException(this.messageList.getMessage("config20", "The WS-I Test Assertion Document (TAD)document was either not found or could not be processed."));
                    }
                    report = this.documentFactory.newReport();
                    report.setLocation(this.getAnalyzerConfig().getReportLocation());
                    ReportContext reportContext = new ReportContext("WS-I Basic Profile Conformance Report.", this.profileAssertions, this);
                    report.setReportContext(reportContext);
                    reportWriter = this.documentFactory.newReportWriter();
                    reportWriter.setWriter(this.getAnalyzerConfig().getReportLocation());
                    this.reporter = new DefaultReporter(report, (ReportWriter)reportWriter);
                    if (this.wsdlDocument == null && this.getAnalyzerConfig().isUDDIReferenceSet()) {
                        this.wsdlDocument = this.getWsdlFromUddi();
                    }
                    if (this.wsdlDocument == null && this.getAnalyzerConfig().isWSDLReferenceSet()) {
                        this.wsdlDocument = new WSDLDocument(this.getAnalyzerConfig().getWSDLLocation());
                        if (this.wsdlDocument == null) {
                            throw new WSIException(this.messageList.getMessage("config05", "WSDL document was either not found or could not be processed."));
                        }
                    }
                    if (WSDLUtils.isSOAP12WSDL(this.wsdlDocument) && this.getAnalyzerConfig().getLogLocation() != null) {
                        this.getAnalyzerConfig().setWSDLReference(null);
                    } else {
                        this.analyzerContext.setWsdlDocument(this.wsdlDocument);
                    }
                    this.reporter.startReport();
                    this.profileAssertions.getArtifactList().keySet().iterator();
                    Iterator i = this.profileAssertions.getArtifactList().keySet().iterator();
                    while (true) {
                        block14: {
                            if (i.hasNext()) break block14;
                            this.reporter.finishReport();
                            break;
                        }
                        String artifactType = (String)i.next();
                        reportArtifact = this.setCurrentArtifact(ArtifactType.getArtifactType(artifactType));
                        this.validate(reportArtifact, this.factory.getValidatorForArtifact(artifactType));
                        this.reporter.endCurrentArtifact();
                    }
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    String message = this.messageList.getMessage("error03", "The conformance validation process failed.");
                    if (this.reporter != null) {
                        pw.println(message);
                        pw.println(String.valueOf(this.messageList.getMessage("exception01", "Exception: ")) + e.getClass().getName());
                        e.printStackTrace(pw);
                        this.reporter.finishReportWithError(sw.toString());
                    }
                    if (!(e instanceof WSIException)) throw new WSIException(message, e);
                    throw (WSIException)e;
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (reportWriter == null) throw throwable;
                reportWriter.close();
                throw throwable;
            }
            {
                Object var9_14 = null;
                if (reportWriter == null) break block13;
            }
            reportWriter.close();
        }
        if (report == null) return statusCode;
        if (!report.getSummaryResult().equals("passed")) return 1;
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validate(ReportArtifact reportArtifact, BaseValidator validator) throws WSIException {
        try {
            if (validator instanceof WSDLValidatorImpl) {
                ((WSDLValidatorImpl)validator).init(this.analyzerContext, this.profileAssertions, reportArtifact, this.getAnalyzerConfig(), this.reporter, this.getAnalyzerConfigIndex() == 0);
            } else {
                validator.init(this.analyzerContext, this.profileAssertions, reportArtifact, this.getAnalyzerConfig(), this.reporter);
            }
            if (validator.runTests()) {
                validator.validateArtifact();
            } else {
                validator.setAllMissingInput();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            validator.cleanup();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        validator.cleanup();
    }

    public static void main(String[] args) throws IOException {
        int statusCode;
        block6: {
            statusCode = 0;
            BasicProfileAnalyzer analyzer = null;
            try {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", WSIProperties.getProperty("javax.xml.parsers.DocumentBuilderFactory"));
                System.setProperty("org.uddi4j.TransportClassName", WSIProperties.getProperty("org.uddi4j.TransportClassName"));
                analyzer = new BasicProfileAnalyzer(args);
                statusCode = ((Analyzer)analyzer).validateConformance();
                analyzer.printMessage("created01", null, "Conformance report has been created.");
            }
            catch (Exception e) {
                String messageData;
                String defaultMessage;
                String messageID;
                statusCode = 1;
                if (e instanceof WSIFileNotFoundException || e instanceof IllegalArgumentException) {
                    messageID = "error01";
                    defaultMessage = "Analyzer Error:";
                    messageData = e.getMessage();
                } else {
                    messageID = "error02";
                    defaultMessage = "Analyzer Stopped By Exception:";
                    messageData = e.toString();
                }
                if (analyzer != null) {
                    analyzer.printMessage(messageID, messageData, defaultMessage);
                } else {
                    Analyzer.staticPrintMessage(messageID, messageData, defaultMessage);
                }
                if (analyzer == null || analyzer.getAnalyzerConfig() == null || !analyzer.getAnalyzerConfig().getVerboseOption()) break block6;
                BasicProfileAnalyzer.dump(e);
            }
        }
        System.exit(statusCode);
    }

    protected ReportArtifact setCurrentArtifact(ArtifactType artifactType) throws WSIException {
        ReportArtifact reportArtifact = this.reporter.createArtifact();
        reportArtifact.setType(artifactType);
        this.reporter.setCurrentArtifact(reportArtifact);
        return reportArtifact;
    }

    public static void dump(Throwable t) {
        while (t instanceof WSIException) {
            Throwable nested = ((WSIException)t).getTargetException();
            if (nested == null) break;
            t = nested;
        }
        t.printStackTrace();
    }
}

