/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.extension.RegistryReader;
import org.osgi.framework.Bundle;

public class FormatProcessorsExtensionReader
extends RegistryReader {
    private static FormatProcessorsExtensionReader instance;
    private Map map = new HashMap();
    String processorClassName;

    public static synchronized FormatProcessorsExtensionReader getInstance() {
        if (instance == null) {
            instance = new FormatProcessorsExtensionReader();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            instance.readRegistry(registry, "org.eclipse.wst.sse.core", "formatProcessors");
        }
        return instance;
    }

    public IStructuredFormatProcessor getFormatProcessor(String contentTypeId) {
        if (contentTypeId == null) {
            return null;
        }
        IStructuredFormatProcessor formatProcessor = null;
        if (this.map.containsKey(contentTypeId)) {
            formatProcessor = (IStructuredFormatProcessor)this.map.get(contentTypeId);
        } else {
            IContentTypeManager manager = Platform.getContentTypeManager();
            IContentType queryContentType = manager.getContentType(contentTypeId);
            boolean found = false;
            for (String elementContentTypeId : this.map.keySet()) {
                IContentType elementContentType = manager.getContentType(elementContentTypeId);
                if (!queryContentType.isKindOf(elementContentType)) continue;
                formatProcessor = (IStructuredFormatProcessor)this.map.get(elementContentTypeId);
                this.map.put(contentTypeId, formatProcessor);
                found = true;
                break;
            }
            if (!found) {
                this.map.put(contentTypeId, null);
            }
        }
        return formatProcessor;
    }

    @Override
    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals("processor")) {
            String contentTypeId = element.getAttribute("contentTypeId");
            String processorClassName = element.getAttribute("class");
            String pluginID = element.getDeclaringExtension().getNamespace();
            Bundle bundle = Platform.getBundle((String)pluginID);
            try {
                IStructuredFormatProcessor processor = (IStructuredFormatProcessor)bundle.loadClass(processorClassName).newInstance();
                this.map.put(contentTypeId, processor);
                return true;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

