/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTBinaryTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.core.runtime.CoreException;

public class EvalBinaryTypeId
extends CPPDependentEvaluation {
    private final IASTBinaryTypeIdExpression.Operator fOperator;
    private final IType fType1;
    private final IType fType2;
    private boolean fCheckedValueDependent;
    private boolean fIsValueDependent;

    public EvalBinaryTypeId(IASTBinaryTypeIdExpression.Operator kind, IType type1, IType type2, IASTNode pointOfDefinition) {
        this(kind, type1, type2, EvalBinaryTypeId.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalBinaryTypeId(IASTBinaryTypeIdExpression.Operator kind, IType type1, IType type2, IBinding templateDefinition) {
        super(templateDefinition);
        this.fOperator = kind;
        this.fType1 = type1;
        this.fType2 = type2;
    }

    public IASTBinaryTypeIdExpression.Operator getOperator() {
        return this.fOperator;
    }

    public IType getType1() {
        return this.fType1;
    }

    public IType getType2() {
        return this.fType2;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public IType getType() {
        switch (this.fOperator) {
            case __is_base_of: 
            case __is_trivially_assignable: {
                return CPPBasicType.BOOLEAN;
            }
        }
        return ProblemType.UNKNOWN_FOR_EXPRESSION;
    }

    @Override
    public IValue getValue() {
        if (this.isValueDependent()) {
            return DependentValue.create(this);
        }
        return ValueFactory.evaluateBinaryTypeIdExpression(this.fOperator, this.fType1, this.fType2);
    }

    @Override
    public boolean isTypeDependent() {
        return false;
    }

    @Override
    public boolean isValueDependent() {
        if (!this.fCheckedValueDependent) {
            this.fIsValueDependent = CPPTemplates.isDependentType(this.fType1) || CPPTemplates.isDependentType(this.fType2);
            this.fCheckedValueDependent = true;
        }
        return this.fIsValueDependent;
    }

    @Override
    public boolean isConstantExpression() {
        return true;
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalBinaryTypeId)) {
            return false;
        }
        EvalBinaryTypeId o = (EvalBinaryTypeId)other;
        return this.fOperator == o.fOperator && this.fType1.isSameType(o.fType1) && this.fType2.isSameType(o.fType2);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)2);
        buffer.putByte((byte)this.fOperator.ordinal());
        buffer.marshalType(this.fType1);
        buffer.marshalType(this.fType2);
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int op = buffer.getByte();
        IType arg1 = buffer.unmarshalType();
        IType arg2 = buffer.unmarshalType();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalBinaryTypeId(IASTBinaryTypeIdExpression.Operator.values()[op], arg1, arg2, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        IType type1 = CPPTemplates.instantiateType(this.fType1, context);
        IType type2 = CPPTemplates.instantiateType(this.fType2, context);
        if (type1 == this.fType1 && type2 == this.fType2) {
            return this;
        }
        return new EvalBinaryTypeId(this.fOperator, type1, type2, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        return this;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return CPPTemplates.combinePackSize(CPPTemplates.determinePackSize(this.fType1, tpMap), CPPTemplates.determinePackSize(this.fType2, tpMap));
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.isValueDependent();
    }

    @Override
    public boolean isNoexcept() {
        return true;
    }
}

