/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.oci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.OracleDataSourceProvider;
import org.jkiss.dbeaver.ext.oracle.oci.OCIUtils;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.LocalNativeClientLocation;
import org.jkiss.utils.CommonUtils;

public class OracleHomeDescriptor
extends LocalNativeClientLocation {
    private static final Log log = Log.getLog(OracleHomeDescriptor.class);
    private Integer oraVersion = OracleDataSourceProvider.getOracleVersion((DBPNativeClientLocation)this);
    private String displayName;
    private List<String> tnsNames;

    public OracleHomeDescriptor(String oraHome) {
        super(CommonUtils.removeTrailingSlash((String)oraHome), oraHome);
        if (this.oraVersion == null) {
            log.debug((Object)("Unrecognized Oracle client version at " + oraHome));
        }
        this.displayName = OCIUtils.readWinRegistry(oraHome, "ORACLE_HOME_NAME");
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getName();
    }

    public Collection<String> getOraServiceNames() {
        if (this.tnsNames == null) {
            this.tnsNames = new ArrayList<String>(OCIUtils.readTnsNames(this.getPath(), true).keySet());
        }
        return this.tnsNames;
    }
}

