"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var path_1 = require("path");
var crypto_1 = require("crypto");
var fs_extra_1 = require("fs-extra");
var lodash_1 = require("lodash");
var memoizedRegexp = lodash_1.memoize(RegExp);
var cachedTest = function (reString, subject) {
    if (reString == null) {
        return false;
    }
    return memoizedRegexp(reString).test(subject);
};
var cachedMd5 = lodash_1.memoize(function (path) {
    return crypto_1.createHash('md5')
        .update(path)
        .digest('hex');
});
function cacheFile(jestConfig, filePath, src) {
    if (!cachedTest(jestConfig.testRegex, filePath)) {
        var hash = cachedMd5(filePath);
        var outputFilePath = path_1.join(jestConfig.cacheDirectory, 'ts-jest', hash);
        fs_extra_1.outputFileSync(outputFilePath, src);
    }
}
exports.cacheFile = cacheFile;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FjaGUtZmlsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlscy9jYWNoZS1maWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsNkJBQTRCO0FBQzVCLGlDQUFvQztBQUNwQyxxQ0FBMEM7QUFDMUMsaUNBQWlDO0FBSWpDLElBQU0sY0FBYyxHQUFHLGdCQUFPLENBQUMsTUFBTSxDQUFDLENBQUM7QUFDdkMsSUFBTSxVQUFVLEdBQUcsVUFDakIsUUFBbUMsRUFDbkMsT0FBZTtJQUVmLElBQUksUUFBUSxJQUFJLElBQUksRUFBRTtRQUNwQixPQUFPLEtBQUssQ0FBQztLQUNkO0lBQ0QsT0FBTyxjQUFjLENBQUMsUUFBUSxDQUFDLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0FBQ2hELENBQUMsQ0FBQztBQUVGLElBQU0sU0FBUyxHQUFHLGdCQUFPLENBQUMsVUFBQyxJQUFZO0lBQ3JDLE9BQUEsbUJBQVUsQ0FBQyxLQUFLLENBQUM7U0FDZCxNQUFNLENBQUMsSUFBSSxDQUFDO1NBQ1osTUFBTSxDQUFDLEtBQUssQ0FBQztBQUZoQixDQUVnQixDQUNqQixDQUFDO0FBSUYsbUJBQ0UsVUFBOEIsRUFDOUIsUUFBZ0IsRUFDaEIsR0FBVztJQUdYLElBQUksQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLFNBQVMsRUFBRSxRQUFRLENBQUMsRUFBRTtRQUMvQyxJQUFNLElBQUksR0FBRyxTQUFTLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDakMsSUFBTSxjQUFjLEdBQUcsV0FBSSxDQUFDLFVBQVUsQ0FBQyxjQUFjLEVBQUUsU0FBUyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3hFLHlCQUFjLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxDQUFDO0tBQ3JDO0FBQ0gsQ0FBQztBQVhELDhCQVdDIn0=