import { __assign } from 'tslib';
import { Injectable, Component, Input, ViewEncapsulation, ViewChild, ComponentRef, TemplateRef, ComponentFactoryResolver, ViewContainerRef, ChangeDetectorRef, Directive, Renderer2, NgModule, InjectionToken } from '@angular/core';
import { ReplaySubject } from 'rxjs';
import { CommonModule } from '@angular/common';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIActions = /** @class */ (function () {
    function BlockUIActions() {
    }
    BlockUIActions.START = 'start';
    BlockUIActions.STOP = 'stop';
    BlockUIActions.UPDATE = 'update';
    BlockUIActions.RESET = 'reset';
    BlockUIActions.UNSUBSCRIBE = 'unsubscribe';
    return BlockUIActions;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var /** @type {?} */ BlockUIDefaultName = "block-ui-main";

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIInstanceService = /** @class */ (function () {
    function BlockUIInstanceService() {
        this.blockUISettings = {};
        this.blockUIInstances = {};
        this.blockUISubject = new ReplaySubject();
        this.blockUIObservable = this.blockUISubject.asObservable();
        this.blockUIObservable.subscribe(this.blockUIMiddleware.bind(this));
    }
    /**
     * @return {?}
     */
    BlockUIInstanceService.prototype.getSettings = /**
     * @return {?}
     */
    function () {
        return this.blockUISettings;
    };
    /**
     * @param {?=} settings
     * @return {?}
     */
    BlockUIInstanceService.prototype.updateSettings = /**
     * @param {?=} settings
     * @return {?}
     */
    function (settings) {
        if (settings === void 0) { settings = {}; }
        this.blockUISettings = __assign({}, this.blockUISettings, settings);
    };
    /**
     * @param {?=} name
     * @return {?}
     */
    BlockUIInstanceService.prototype.decorate = /**
     * @param {?=} name
     * @return {?}
     */
    function (name) {
        if (name === void 0) { name = BlockUIDefaultName; }
        var /** @type {?} */ blockUI = /** @type {?} */ ({
            name: name,
            isActive: false,
            blockCount: 0,
            start: this.dispatch(this.blockUISubject, BlockUIActions.START, name),
            update: this.dispatch(this.blockUISubject, BlockUIActions.UPDATE, name),
            stop: this.dispatch(this.blockUISubject, BlockUIActions.STOP, name),
            reset: this.dispatch(this.blockUISubject, BlockUIActions.RESET, name),
            unsubscribe: this.dispatch(this.blockUISubject, BlockUIActions.UNSUBSCRIBE, name)
        });
        this.blockUIInstances[name] = this.blockUIInstances[name] || blockUI;
        return blockUI;
    };
    /**
     * @return {?}
     */
    BlockUIInstanceService.prototype.observe = /**
     * @return {?}
     */
    function () {
        return this.blockUIObservable;
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIInstanceService.prototype.blockUIMiddleware = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var action = _a.action, name = _a.name;
        var /** @type {?} */ isActive = null;
        switch (action) {
            case (BlockUIActions.START):
                isActive = true;
                break;
            case (BlockUIActions.STOP):
            case (BlockUIActions.RESET):
                isActive = false;
                break;
        }
        if (isActive !== null) {
            this.blockUIInstances[name].isActive = isActive;
        }
    };
    /**
     * @param {?} subject
     * @param {?} action
     * @param {?=} name
     * @return {?}
     */
    BlockUIInstanceService.prototype.dispatch = /**
     * @param {?} subject
     * @param {?} action
     * @param {?=} name
     * @return {?}
     */
    function (subject, action, name) {
        if (name === void 0) { name = BlockUIDefaultName; }
        return function (message) {
            subject.next({
                name: name,
                action: action,
                message: message
            });
        };
    };
    BlockUIInstanceService.decorators = [
        { type: Injectable },
    ];
    /** @nocollapse */
    BlockUIInstanceService.ctorParameters = function () { return []; };
    return BlockUIInstanceService;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIComponent = /** @class */ (function () {
    function BlockUIComponent(blockUI) {
        this.blockUI = blockUI;
    }
    /**
     * @return {?}
     */
    BlockUIComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        this.name = this.name || BlockUIDefaultName;
        this.template = this.template || this.blockUI.blockUISettings.template;
    };
    BlockUIComponent.decorators = [
        { type: Component, args: [{
                    selector: 'block-ui',
                    template: "\n    <ng-content></ng-content>\n    <block-ui-content\n      [name]=\"name\"\n      [message]=\"message\"\n      [template]=\"template\"\n      [delayStart]=\"delayStart\"\n      [delayStop]=\"delayStop\"\n    >\n    </block-ui-content>\n  ",
                    encapsulation: ViewEncapsulation.None
                },] },
    ];
    /** @nocollapse */
    BlockUIComponent.ctorParameters = function () { return [
        { type: BlockUIInstanceService }
    ]; };
    BlockUIComponent.propDecorators = {
        name: [{ type: Input }],
        message: [{ type: Input }],
        delayStart: [{ type: Input }],
        delayStop: [{ type: Input }],
        template: [{ type: Input }]
    };
    return BlockUIComponent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
// Spinner style - https://github.com/lukehaas/css-loaders
var /** @type {?} */ styles = "\n.block-ui-wrapper {\n  display: none;\n  position: fixed;\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 0;\n  background: rgba(0, 0, 0, 0.70);\n  z-index: 30000;\n  cursor: wait;\n}\n\n.block-ui-wrapper.block-ui-wrapper--element {\n  position: absolute;\n}\n\n.block-ui-wrapper.active {\n  display: block;\n}\n\n.block-ui-wrapper.block-ui-main {\n  position: fixed;\n}\n\n.block-ui-spinner,\n.block-ui-template {\n  position: absolute;\n  top: 40%;\n  margin: 0 auto;\n  left: 0;\n  right: 0;\n  transform: translateY(-50%);\n}\n\n.block-ui-spinner > .message {\n  font-size: 1.3em;\n  text-align: center;\n  color: #fff;\n}\n\n.block-ui__element {\n  position: relative;\n}\n\n.loader,\n.loader:after {\n  border-radius: 50%;\n  width: 10em;\n  height: 10em;\n}\n.loader {\n  margin: 7px auto;\n  font-size: 5px;\n  position: relative;\n  text-indent: -9999em;\n  border-top: 1.1em solid rgba(255, 255, 255, 0.2);\n  border-right: 1.1em solid rgba(255, 255, 255, 0.2);\n  border-bottom: 1.1em solid rgba(255, 255, 255, 0.2);\n  border-left: 1.1em solid #ffffff;\n  -webkit-transform: translateZ(0);\n  -ms-transform: translateZ(0);\n  transform: translateZ(0);\n  -webkit-animation: load8 1.1s infinite linear;\n  animation: load8 1.1s infinite linear;\n}\n\n@-webkit-keyframes load8 {\n  0% {\n    -webkit-transform: rotate(0deg);\n    transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n\n@keyframes load8 {\n  0% {\n    -webkit-transform: rotate(0deg);\n    transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n";

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var /** @type {?} */ template = "\n<div class=\"block-ui-wrapper {{name}} {{className}}\" [ngClass]=\"{ 'active': active }\">\n  <div class=\"block-ui-spinner\" *ngIf=\"!templateCmp\">\n    <div class=\"loader\"></div>\n    <div *ngIf=\"message || defaultMessage\" class=\"message\">\n      {{ message || defaultMessage }}\n    </div>\n  </div>\n  <ng-template *ngIf=\"templateCmp\" #templateOutlet></ng-template>\n</div>\n";

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIContentComponent = /** @class */ (function () {
    function BlockUIContentComponent(blockUI, resolver, changeDetectionRef) {
        this.blockUI = blockUI;
        this.resolver = resolver;
        this.changeDetectionRef = changeDetectionRef;
        this.name = BlockUIDefaultName;
        this.delayStart = 0;
        this.delayStop = 0;
        this.state = { startTimeout: null, stopTimeout: null, blockCount: 0 };
        this.active = false;
    }
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        this.settings = this.blockUI.getSettings();
        this.blockUISubscription = this.subscribeToBlockUI(this.blockUI.observe());
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngAfterViewInit = /**
     * @return {?}
     */
    function () {
        try {
            if (!this.templateCmp) {
                return false;
            }
            if (this.templateCmp instanceof TemplateRef) {
                this.templateOutlet.createEmbeddedView(this.templateCmp);
            }
            else {
                var /** @type {?} */ templateComp = this.resolver.resolveComponentFactory(this.templateCmp);
                this.templateCompRef = this.templateOutlet.createComponent(templateComp);
                this.updateBlockTemplate(this.message);
            }
        }
        catch (/** @type {?} */ error) {
            console.error('ng-block-ui:', error);
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngAfterViewChecked = /**
     * @return {?}
     */
    function () {
        this.changeDetectionRef.detectChanges();
    };
    /**
     * @param {?} blockUI$
     * @return {?}
     */
    BlockUIContentComponent.prototype.subscribeToBlockUI = /**
     * @param {?} blockUI$
     * @return {?}
     */
    function (blockUI$) {
        var _this = this;
        return blockUI$
            .subscribe(function (event) { return _this.onDispatchedEvent(event); });
    };
    /**
     * @param {?} event
     * @return {?}
     */
    BlockUIContentComponent.prototype.onDispatchedEvent = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        switch (event.action) {
            case (BlockUIActions.START):
                this.onStart(event);
                break;
            case (BlockUIActions.STOP):
                this.onStop(event);
                break;
            case (BlockUIActions.UPDATE):
                this.onUpdate(event);
                break;
            case (BlockUIActions.RESET):
                this.onReset();
                break;
            case (BlockUIActions.UNSUBSCRIBE):
                this.onStop(event);
                this.onUnsubscribe(event.name);
                break;
        }
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIContentComponent.prototype.onStart = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var _this = this;
        var name = _a.name, message = _a.message;
        if (name === this.name) {
            var /** @type {?} */ delay = this.delayStart || this.settings.delayStart || 0;
            if (delay) {
                if (this.state.startTimeout === null) {
                    this.state.startTimeout = setTimeout(function () {
                        _this.showBlock(message);
                    }, delay);
                }
                this.state.blockCount++;
            }
            else {
                this.showBlock(message);
            }
            this.updateInstanceBlockCount();
        }
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIContentComponent.prototype.onStop = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var _this = this;
        var name = _a.name, action = _a.action;
        if (name === this.name) {
            if (this.state.blockCount > 1) {
                this.state.blockCount--;
            }
            else {
                if (!this.active) {
                    this.clearState();
                }
                else {
                    var /** @type {?} */ delay = this.delayStop || this.settings.delayStop || 0;
                    if (delay) {
                        if (this.state.stopTimeout === null) {
                            this.state.stopTimeout = setTimeout(function () {
                                _this.hideBlock();
                            }, delay);
                        }
                    }
                    else {
                        this.hideBlock();
                    }
                }
            }
            this.updateInstanceBlockCount();
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.onReset = /**
     * @return {?}
     */
    function () {
        this.hideBlock();
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIContentComponent.prototype.onUpdate = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var name = _a.name, message = _a.message;
        if (name === this.name) {
            this.active = true;
            this.message = message || this.defaultMessage || this.settings.message;
            this.updateBlockTemplate(this.message);
            this.changeDetectionRef.detectChanges();
        }
    };
    /**
     * @param {?} message
     * @return {?}
     */
    BlockUIContentComponent.prototype.showBlock = /**
     * @param {?} message
     * @return {?}
     */
    function (message) {
        this.active = true;
        this.message = message || this.defaultMessage || this.settings.message;
        this.updateBlockTemplate(this.message);
        this.changeDetectionRef.detectChanges();
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.hideBlock = /**
     * @return {?}
     */
    function () {
        this.clearState();
        this.active = false;
        this.changeDetectionRef.detectChanges();
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.clearState = /**
     * @return {?}
     */
    function () {
        this.state.startTimeout != null && clearTimeout(this.state.startTimeout);
        this.state.stopTimeout != null && clearTimeout(this.state.stopTimeout);
        this.state.blockCount = 0;
        this.state.startTimeout = null;
        this.state.stopTimeout = null;
        this.updateInstanceBlockCount();
    };
    /**
     * @param {?} msg
     * @return {?}
     */
    BlockUIContentComponent.prototype.updateBlockTemplate = /**
     * @param {?} msg
     * @return {?}
     */
    function (msg) {
        if (this.templateCompRef && this.templateCompRef instanceof ComponentRef) {
            this.templateCompRef.instance.message = msg;
        }
    };
    /**
     * @param {?} name
     * @return {?}
     */
    BlockUIContentComponent.prototype.onUnsubscribe = /**
     * @param {?} name
     * @return {?}
     */
    function (name) {
        if (this.blockUISubscription && name === this.name) {
            this.blockUISubscription.unsubscribe();
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.updateInstanceBlockCount = /**
     * @return {?}
     */
    function () {
        if (this.blockUI.blockUIInstances[this.name]) {
            this.blockUI.blockUIInstances[this.name].blockCount = this.state.blockCount;
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        this.onUnsubscribe(this.name);
    };
    BlockUIContentComponent.decorators = [
        { type: Component, args: [{
                    selector: 'block-ui-content',
                    template: template,
                    styles: [styles],
                    // TODO: Find how to bundle styles for npm
                    encapsulation: ViewEncapsulation.None
                },] },
    ];
    /** @nocollapse */
    BlockUIContentComponent.ctorParameters = function () { return [
        { type: BlockUIInstanceService },
        { type: ComponentFactoryResolver },
        { type: ChangeDetectorRef }
    ]; };
    BlockUIContentComponent.propDecorators = {
        name: [{ type: Input }],
        delayStart: [{ type: Input }],
        delayStop: [{ type: Input }],
        defaultMessage: [{ type: Input, args: ['message',] }],
        templateCmp: [{ type: Input, args: ['template',] }],
        templateOutlet: [{ type: ViewChild, args: ['templateOutlet', { read: ViewContainerRef },] }]
    };
    return BlockUIContentComponent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIService = /** @class */ (function () {
    function BlockUIService(blockUIInstance) {
        this.blockUIInstance = blockUIInstance;
    }
    /**
    * Starts blocking for given BlockUI instance or instances
    */
    /**
     * Starts blocking for given BlockUI instance or instances
     * @param {?} target
     * @param {?=} message
     * @return {?}
     */
    BlockUIService.prototype.start = /**
     * Starts blocking for given BlockUI instance or instances
     * @param {?} target
     * @param {?=} message
     * @return {?}
     */
    function (target, message) {
        this.dispatch(target, BlockUIActions.START, message);
    };
    /**
    * Stops blocking for given BlockUI instance or instances
    */
    /**
     * Stops blocking for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    BlockUIService.prototype.stop = /**
     * Stops blocking for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    function (target) {
        this.dispatch(target, BlockUIActions.STOP);
    };
    /**
    * Unsubscribes for given BlockUI instance or instances
    */
    /**
     * Unsubscribes for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    BlockUIService.prototype.unsubscribe = /**
     * Unsubscribes for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    function (target) {
        this.dispatch(target, BlockUIActions.UNSUBSCRIBE);
    };
    /**
    * Checks if BlockUI is actively blocking
    */
    /**
     * Checks if BlockUI is actively blocking
     * @param {?=} target
     * @return {?}
     */
    BlockUIService.prototype.isActive = /**
     * Checks if BlockUI is actively blocking
     * @param {?=} target
     * @return {?}
     */
    function (target) {
        if (target === void 0) { target = null; }
        var /** @type {?} */ targets = target ? this.toArray(target) : null;
        var /** @type {?} */ instances = this.blockUIInstance.blockUIInstances;
        return Object.keys(instances).some(function (key) {
            if (!targets) {
                return instances[key].isActive;
            }
            return targets.indexOf(instances[key].name) >= 0 && instances[key].isActive;
        });
    };
    /**
     * @param {?=} target
     * @param {?=} type
     * @param {?=} message
     * @return {?}
     */
    BlockUIService.prototype.dispatch = /**
     * @param {?=} target
     * @param {?=} type
     * @param {?=} message
     * @return {?}
     */
    function (target, type, message) {
        var _this = this;
        if (target === void 0) { target = []; }
        var /** @type {?} */ instances = this.toArray(target);
        instances.forEach(function (i) { return _this.blockUIInstance.decorate(i)[type](message); });
    };
    /**
     * @param {?=} target
     * @return {?}
     */
    BlockUIService.prototype.toArray = /**
     * @param {?=} target
     * @return {?}
     */
    function (target) {
        if (target === void 0) { target = []; }
        return typeof target === 'string' ? [target] : target;
    };
    BlockUIService.decorators = [
        { type: Injectable },
    ];
    /** @nocollapse */
    BlockUIService.ctorParameters = function () { return [
        { type: BlockUIInstanceService }
    ]; };
    return BlockUIService;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIDirective = /** @class */ (function () {
    function BlockUIDirective(blockUIService, viewRef, templateRef, renderer, componentFactoryResolver) {
        this.blockUIService = blockUIService;
        this.viewRef = viewRef;
        this.templateRef = templateRef;
        this.renderer = renderer;
        this.componentFactoryResolver = componentFactoryResolver;
    }
    Object.defineProperty(BlockUIDirective.prototype, "blockUI", {
        set: /**
         * @param {?} name
         * @return {?}
         */
        function (name) { this.blockTarget = name; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BlockUIDirective.prototype, "blockUIMessage", {
        set: /**
         * @param {?} message
         * @return {?}
         */
        function (message) { this.message = message; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BlockUIDirective.prototype, "blockUITemplate", {
        set: /**
         * @param {?} template
         * @return {?}
         */
        function (template) { this.template = template; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BlockUIDirective.prototype, "blockUIDelayStart", {
        set: /**
         * @param {?} delayStart
         * @return {?}
         */
        function (delayStart) {
            this.delayStart = delayStart ? Number(delayStart) : null;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BlockUIDirective.prototype, "blockUIDelayStop", {
        set: /**
         * @param {?} delayStop
         * @return {?}
         */
        function (delayStop) {
            this.delayStop = delayStop ? Number(delayStop) : null;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    BlockUIDirective.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        try {
            this.viewRef.createEmbeddedView(this.templateRef);
            var /** @type {?} */ parentElement = this.viewRef.element.nativeElement.nextSibling;
            if (parentElement && !this.isComponentInTemplate(parentElement)) {
                this.renderer.addClass(parentElement, 'block-ui__element');
                this.blockUIComponentRef = this.createComponent();
                var /** @type {?} */ blockUIContent = this.findContentNode(this.viewRef.element.nativeElement);
                if (blockUIContent) {
                    var /** @type {?} */ settings = this.blockUIService.getSettings();
                    parentElement.appendChild(blockUIContent);
                    this.blockUIComponentRef.instance.className = 'block-ui-wrapper--element';
                    this.blockUIComponentRef.instance.name = this.blockTarget || BlockUIDefaultName;
                    if (this.message)
                        this.blockUIComponentRef.instance.defaultMessage = this.message;
                    if (this.delayStart)
                        this.blockUIComponentRef.instance.delayStart = this.delayStart;
                    if (this.delayStop)
                        this.blockUIComponentRef.instance.delayStop = this.delayStop;
                    if (this.template || settings.template)
                        this.blockUIComponentRef.instance.templateCmp = this.template || settings.template;
                }
            }
        }
        catch (/** @type {?} */ error) {
            console.error('ng-block-ui:', error);
        }
    };
    /**
     * @param {?} element
     * @return {?}
     */
    BlockUIDirective.prototype.isComponentInTemplate = /**
     * @param {?} element
     * @return {?}
     */
    function (element) {
        var children = (element || []).children;
        children = Array.from(children).reverse();
        return children.some(function (el) { return el.localName === 'block-ui'; });
    };
    /**
     * @param {?} element
     * @return {?}
     */
    BlockUIDirective.prototype.findContentNode = /**
     * @param {?} element
     * @return {?}
     */
    function (element) {
        var nextSibling = element.nextSibling;
        return [nextSibling, nextSibling.nextSibling].find(function (e) { return e.localName === 'block-ui-content'; });
    };
    /**
     * @return {?}
     */
    BlockUIDirective.prototype.createComponent = /**
     * @return {?}
     */
    function () {
        var /** @type {?} */ resolvedBlockUIComponent = this.componentFactoryResolver.resolveComponentFactory(BlockUIContentComponent);
        return this.viewRef.createComponent(resolvedBlockUIComponent);
    };
    BlockUIDirective.decorators = [
        { type: Directive, args: [{ selector: '[blockUI]' },] },
    ];
    /** @nocollapse */
    BlockUIDirective.ctorParameters = function () { return [
        { type: BlockUIInstanceService },
        { type: ViewContainerRef },
        { type: TemplateRef },
        { type: Renderer2 },
        { type: ComponentFactoryResolver }
    ]; };
    BlockUIDirective.propDecorators = {
        blockUI: [{ type: Input }],
        blockUIMessage: [{ type: Input }],
        blockUITemplate: [{ type: Input }],
        blockUIDelayStart: [{ type: Input }],
        blockUIDelayStop: [{ type: Input }]
    };
    return BlockUIDirective;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var /** @type {?} */ BlockUIServiceInstance = new BlockUIInstanceService();
// Needed for AOT compiling
var /** @type {?} */ BlockUIModuleSettings = new InjectionToken('BlockUIModuleSettings');
/**
 * @param {?} settings
 * @return {?}
 */
function provideInstance(settings) {
    BlockUIServiceInstance.updateSettings(settings);
    return BlockUIServiceInstance;
}
var BlockUIModule = /** @class */ (function () {
    function BlockUIModule() {
    }
    /**
     * @param {?=} settings
     * @return {?}
     */
    BlockUIModule.forRoot = /**
     * @param {?=} settings
     * @return {?}
     */
    function (settings) {
        if (settings === void 0) { settings = {}; }
        return {
            ngModule: BlockUIModule,
            providers: [
                {
                    provide: BlockUIModuleSettings,
                    useValue: settings
                },
                {
                    provide: BlockUIInstanceService,
                    useFactory: provideInstance,
                    deps: [BlockUIModuleSettings]
                },
                BlockUIService
            ]
        };
    };
    BlockUIModule.decorators = [
        { type: NgModule, args: [{
                    imports: [
                        CommonModule
                    ],
                    entryComponents: [
                        BlockUIComponent,
                        BlockUIContentComponent
                    ],
                    declarations: [
                        BlockUIComponent,
                        BlockUIDirective,
                        BlockUIContentComponent
                    ],
                    exports: [
                        BlockUIComponent,
                        BlockUIDirective,
                        BlockUIContentComponent
                    ]
                },] },
    ];
    return BlockUIModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @param {?=} value
 * @return {?}
 */
function BlockUI(value) {
    return function (target, propertyKey, descriptor) {
        target[propertyKey] = BlockUIServiceInstance.decorate(value);
    };
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

export { BlockUIModule, BlockUIComponent, BlockUIContentComponent, BlockUI, BlockUIService, BlockUIDefaultName as BLOCKUI_DEFAULT, BlockUIModuleSettings as ɵa, provideInstance as ɵb, styles as ɵe, template as ɵd, BlockUIDirective as ɵf, BlockUIInstanceService as ɵc };

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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