/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Component, ViewEncapsulation, Input, ViewChild, ComponentRef, TemplateRef, ComponentFactoryResolver, ViewContainerRef, ChangeDetectorRef } from '@angular/core';
import { BlockUIInstanceService } from '../../services/block-ui-instance.service';
import { BlockUIActions } from '../../constants/block-ui-actions.constant';
import { BlockUIDefaultName } from '../../constants/block-ui-default-name.constant';
import { styles } from './block-ui-content.component.style';
import { template } from './block-ui-content.component.template';
var BlockUIContentComponent = /** @class */ (function () {
    function BlockUIContentComponent(blockUI, resolver, changeDetectionRef) {
        this.blockUI = blockUI;
        this.resolver = resolver;
        this.changeDetectionRef = changeDetectionRef;
        this.name = BlockUIDefaultName;
        this.delayStart = 0;
        this.delayStop = 0;
        this.state = { startTimeout: null, stopTimeout: null, blockCount: 0 };
        this.active = false;
    }
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        this.settings = this.blockUI.getSettings();
        this.blockUISubscription = this.subscribeToBlockUI(this.blockUI.observe());
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngAfterViewInit = /**
     * @return {?}
     */
    function () {
        try {
            if (!this.templateCmp) {
                return false;
            }
            if (this.templateCmp instanceof TemplateRef) {
                this.templateOutlet.createEmbeddedView(this.templateCmp);
            }
            else {
                var /** @type {?} */ templateComp = this.resolver.resolveComponentFactory(this.templateCmp);
                this.templateCompRef = this.templateOutlet.createComponent(templateComp);
                this.updateBlockTemplate(this.message);
            }
        }
        catch (/** @type {?} */ error) {
            console.error('ng-block-ui:', error);
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngAfterViewChecked = /**
     * @return {?}
     */
    function () {
        this.changeDetectionRef.detectChanges();
    };
    /**
     * @param {?} blockUI$
     * @return {?}
     */
    BlockUIContentComponent.prototype.subscribeToBlockUI = /**
     * @param {?} blockUI$
     * @return {?}
     */
    function (blockUI$) {
        var _this = this;
        return blockUI$
            .subscribe(function (event) { return _this.onDispatchedEvent(event); });
    };
    /**
     * @param {?} event
     * @return {?}
     */
    BlockUIContentComponent.prototype.onDispatchedEvent = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        switch (event.action) {
            case (BlockUIActions.START):
                this.onStart(event);
                break;
            case (BlockUIActions.STOP):
                this.onStop(event);
                break;
            case (BlockUIActions.UPDATE):
                this.onUpdate(event);
                break;
            case (BlockUIActions.RESET):
                this.onReset();
                break;
            case (BlockUIActions.UNSUBSCRIBE):
                this.onStop(event);
                this.onUnsubscribe(event.name);
                break;
        }
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIContentComponent.prototype.onStart = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var _this = this;
        var name = _a.name, message = _a.message;
        if (name === this.name) {
            var /** @type {?} */ delay = this.delayStart || this.settings.delayStart || 0;
            if (delay) {
                if (this.state.startTimeout === null) {
                    this.state.startTimeout = setTimeout(function () {
                        _this.showBlock(message);
                    }, delay);
                }
                this.state.blockCount++;
            }
            else {
                this.showBlock(message);
            }
            this.updateInstanceBlockCount();
        }
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIContentComponent.prototype.onStop = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var _this = this;
        var name = _a.name, action = _a.action;
        if (name === this.name) {
            if (this.state.blockCount > 1) {
                this.state.blockCount--;
            }
            else {
                if (!this.active) {
                    this.clearState();
                }
                else {
                    var /** @type {?} */ delay = this.delayStop || this.settings.delayStop || 0;
                    if (delay) {
                        if (this.state.stopTimeout === null) {
                            this.state.stopTimeout = setTimeout(function () {
                                _this.hideBlock();
                            }, delay);
                        }
                    }
                    else {
                        this.hideBlock();
                    }
                }
            }
            this.updateInstanceBlockCount();
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.onReset = /**
     * @return {?}
     */
    function () {
        this.hideBlock();
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIContentComponent.prototype.onUpdate = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var name = _a.name, message = _a.message;
        if (name === this.name) {
            this.active = true;
            this.message = message || this.defaultMessage || this.settings.message;
            this.updateBlockTemplate(this.message);
            this.changeDetectionRef.detectChanges();
        }
    };
    /**
     * @param {?} message
     * @return {?}
     */
    BlockUIContentComponent.prototype.showBlock = /**
     * @param {?} message
     * @return {?}
     */
    function (message) {
        this.active = true;
        this.message = message || this.defaultMessage || this.settings.message;
        this.updateBlockTemplate(this.message);
        this.changeDetectionRef.detectChanges();
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.hideBlock = /**
     * @return {?}
     */
    function () {
        this.clearState();
        this.active = false;
        this.changeDetectionRef.detectChanges();
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.clearState = /**
     * @return {?}
     */
    function () {
        this.state.startTimeout != null && clearTimeout(this.state.startTimeout);
        this.state.stopTimeout != null && clearTimeout(this.state.stopTimeout);
        this.state.blockCount = 0;
        this.state.startTimeout = null;
        this.state.stopTimeout = null;
        this.updateInstanceBlockCount();
    };
    /**
     * @param {?} msg
     * @return {?}
     */
    BlockUIContentComponent.prototype.updateBlockTemplate = /**
     * @param {?} msg
     * @return {?}
     */
    function (msg) {
        if (this.templateCompRef && this.templateCompRef instanceof ComponentRef) {
            this.templateCompRef.instance.message = msg;
        }
    };
    /**
     * @param {?} name
     * @return {?}
     */
    BlockUIContentComponent.prototype.onUnsubscribe = /**
     * @param {?} name
     * @return {?}
     */
    function (name) {
        if (this.blockUISubscription && name === this.name) {
            this.blockUISubscription.unsubscribe();
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.updateInstanceBlockCount = /**
     * @return {?}
     */
    function () {
        if (this.blockUI.blockUIInstances[this.name]) {
            this.blockUI.blockUIInstances[this.name].blockCount = this.state.blockCount;
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        this.onUnsubscribe(this.name);
    };
    BlockUIContentComponent.decorators = [
        { type: Component, args: [{
                    selector: 'block-ui-content',
                    template: template,
                    styles: [styles],
                    // TODO: Find how to bundle styles for npm
                    encapsulation: ViewEncapsulation.None
                },] },
    ];
    /** @nocollapse */
    BlockUIContentComponent.ctorParameters = function () { return [
        { type: BlockUIInstanceService },
        { type: ComponentFactoryResolver },
        { type: ChangeDetectorRef }
    ]; };
    BlockUIContentComponent.propDecorators = {
        name: [{ type: Input }],
        delayStart: [{ type: Input }],
        delayStop: [{ type: Input }],
        defaultMessage: [{ type: Input, args: ['message',] }],
        templateCmp: [{ type: Input, args: ['template',] }],
        templateOutlet: [{ type: ViewChild, args: ['templateOutlet', { read: ViewContainerRef },] }]
    };
    return BlockUIContentComponent;
}());
export { BlockUIContentComponent };
function BlockUIContentComponent_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIContentComponent.prototype.name;
    /** @type {?} */
    BlockUIContentComponent.prototype.delayStart;
    /** @type {?} */
    BlockUIContentComponent.prototype.delayStop;
    /** @type {?} */
    BlockUIContentComponent.prototype.defaultMessage;
    /** @type {?} */
    BlockUIContentComponent.prototype.templateCmp;
    /** @type {?} */
    BlockUIContentComponent.prototype.templateOutlet;
    /** @type {?} */
    BlockUIContentComponent.prototype.state;
    /** @type {?} */
    BlockUIContentComponent.prototype.className;
    /** @type {?} */
    BlockUIContentComponent.prototype.active;
    /** @type {?} */
    BlockUIContentComponent.prototype.templateCompRef;
    /** @type {?} */
    BlockUIContentComponent.prototype.message;
    /** @type {?} */
    BlockUIContentComponent.prototype.blockUISubscription;
    /** @type {?} */
    BlockUIContentComponent.prototype.settings;
    /** @type {?} */
    BlockUIContentComponent.prototype.blockUI;
    /** @type {?} */
    BlockUIContentComponent.prototype.resolver;
    /** @type {?} */
    BlockUIContentComponent.prototype.changeDetectionRef;
}

//# sourceMappingURL=data:application/json;base64,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