/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.turbine.bytecode.AnnotationWriter;
import com.google.turbine.bytecode.Attribute;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ConstantPool;
import com.google.turbine.model.Const;
import java.util.List;

public class AttributeWriter {
    private final ConstantPool pool;
    private final ByteArrayDataOutput output;

    public AttributeWriter(ConstantPool pool, ByteArrayDataOutput output) {
        this.pool = pool;
        this.output = output;
    }

    public void write(Attribute attribute) {
        switch (attribute.kind()) {
            case SIGNATURE: {
                this.writeSignatureAttribute((Attribute.Signature)attribute);
                break;
            }
            case EXCEPTIONS: {
                this.writeExceptionsAttribute((Attribute.ExceptionsAttribute)attribute);
                break;
            }
            case INNER_CLASSES: {
                this.writeInnerClasses((Attribute.InnerClasses)attribute);
                break;
            }
            case CONSTANT_VALUE: {
                this.writeConstantValue((Attribute.ConstantValue)attribute);
                break;
            }
            case RUNTIME_VISIBLE_ANNOTATIONS: 
            case RUNTIME_INVISIBLE_ANNOTATIONS: {
                this.writeAnnotation((Attribute.Annotations)attribute);
                break;
            }
            case ANNOTATION_DEFAULT: {
                this.writeAnnotationDefault((Attribute.AnnotationDefault)attribute);
                break;
            }
            case RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS: 
            case RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS: {
                this.writeParameterAnnotations((Attribute.ParameterAnnotations)attribute);
                break;
            }
            case DEPRECATED: {
                this.writeDeprecated(attribute);
                break;
            }
            case RUNTIME_INVISIBLE_TYPE_ANNOTATIONS: 
            case RUNTIME_VISIBLE_TYPE_ANNOTATIONS: {
                this.writeTypeAnnotation((Attribute.TypeAnnotations)attribute);
                break;
            }
            case METHOD_PARAMETERS: {
                this.writeMethodParameters((Attribute.MethodParameters)attribute);
                break;
            }
            case MODULE: {
                this.writeModule((Attribute.Module)attribute);
            }
        }
    }

    private void writeInnerClasses(Attribute.InnerClasses attribute) {
        this.output.writeShort(this.pool.utf8(attribute.kind().signature()));
        this.output.writeInt(attribute.inners.size() * 8 + 2);
        this.output.writeShort(attribute.inners.size());
        for (ClassFile.InnerClass inner : attribute.inners) {
            this.output.writeShort(this.pool.classInfo(inner.innerClass()));
            this.output.writeShort(this.pool.classInfo(inner.outerClass()));
            this.output.writeShort(this.pool.utf8(inner.innerName()));
            this.output.writeShort(inner.access());
        }
    }

    private void writeExceptionsAttribute(Attribute.ExceptionsAttribute attribute) {
        this.output.writeShort(this.pool.utf8(attribute.kind().signature()));
        this.output.writeInt(2 + attribute.exceptions.size() * 2);
        this.output.writeShort(attribute.exceptions.size());
        for (String exception : attribute.exceptions) {
            this.output.writeShort(this.pool.classInfo(exception));
        }
    }

    private void writeSignatureAttribute(Attribute.Signature attribute) {
        this.output.writeShort(this.pool.utf8(attribute.kind().signature()));
        this.output.writeInt(2);
        this.output.writeShort(this.pool.utf8(attribute.signature));
    }

    public void writeConstantValue(Attribute.ConstantValue attribute) {
        this.output.writeShort(this.pool.utf8(attribute.kind().signature()));
        this.output.writeInt(2);
        Const.Value value = attribute.value;
        switch (value.constantTypeKind()) {
            case INT: 
            case CHAR: 
            case SHORT: 
            case BYTE: {
                this.output.writeShort(this.pool.integer(value.asInteger().value()));
                break;
            }
            case LONG: {
                this.output.writeShort(this.pool.longInfo(value.asLong().value()));
                break;
            }
            case DOUBLE: {
                this.output.writeShort(this.pool.doubleInfo(value.asDouble().value()));
                break;
            }
            case FLOAT: {
                this.output.writeShort(this.pool.floatInfo(value.asFloat().value()));
                break;
            }
            case BOOLEAN: {
                this.output.writeShort(this.pool.integer(value.asBoolean().value() ? 1 : 0));
                break;
            }
            case STRING: {
                this.output.writeShort(this.pool.string(value.asString().value()));
                break;
            }
            default: {
                throw new AssertionError((Object)value.constantTypeKind());
            }
        }
    }

    public void writeAnnotation(Attribute.Annotations attribute) {
        this.output.writeShort(this.pool.utf8(attribute.kind().signature()));
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        tmp.writeShort(attribute.annotations().size());
        for (ClassFile.AnnotationInfo annotation : attribute.annotations()) {
            new AnnotationWriter(this.pool, tmp).writeAnnotation(annotation);
        }
        byte[] data = tmp.toByteArray();
        this.output.writeInt(data.length);
        this.output.write(data);
    }

    public void writeAnnotationDefault(Attribute.AnnotationDefault attribute) {
        this.output.writeShort(this.pool.utf8(attribute.kind().signature()));
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        new AnnotationWriter(this.pool, tmp).writeElementValue(attribute.value());
        byte[] data = tmp.toByteArray();
        this.output.writeInt(data.length);
        this.output.write(data);
    }

    public void writeParameterAnnotations(Attribute.ParameterAnnotations attribute) {
        this.output.writeShort(this.pool.utf8(attribute.kind().signature()));
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        tmp.writeByte(attribute.annotations().size());
        for (List<ClassFile.AnnotationInfo> parameterAnnotations : attribute.annotations()) {
            tmp.writeShort(parameterAnnotations.size());
            for (ClassFile.AnnotationInfo annotation : parameterAnnotations) {
                new AnnotationWriter(this.pool, tmp).writeAnnotation(annotation);
            }
        }
        byte[] data = tmp.toByteArray();
        this.output.writeInt(data.length);
        this.output.write(data);
    }

    private void writeDeprecated(Attribute attribute) {
        this.output.writeShort(this.pool.utf8(attribute.kind().signature()));
        this.output.writeInt(0);
    }

    private void writeTypeAnnotation(Attribute.TypeAnnotations attribute) {
        this.output.writeShort(this.pool.utf8(attribute.kind().signature()));
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        tmp.writeShort(attribute.annotations().size());
        for (ClassFile.TypeAnnotationInfo annotation : attribute.annotations()) {
            new AnnotationWriter(this.pool, tmp).writeTypeAnnotation(annotation);
        }
        byte[] data = tmp.toByteArray();
        this.output.writeInt(data.length);
        this.output.write(data);
    }

    private void writeMethodParameters(Attribute.MethodParameters attribute) {
        this.output.writeShort(this.pool.utf8(attribute.kind().signature()));
        this.output.writeInt(attribute.parameters().size() * 4 + 1);
        this.output.writeByte(attribute.parameters().size());
        for (ClassFile.MethodInfo.ParameterInfo parameter : attribute.parameters()) {
            this.output.writeShort(parameter.name() != null ? this.pool.utf8(parameter.name()) : 0);
            this.output.writeShort(parameter.access());
        }
    }

    private void writeModule(Attribute.Module attribute) {
        ClassFile.ModuleInfo module = attribute.module();
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        tmp.writeShort(this.pool.moduleInfo(module.name()));
        tmp.writeShort(module.flags());
        tmp.writeShort(module.version() != null ? this.pool.utf8(module.version()) : 0);
        tmp.writeShort(module.requires().size());
        for (ClassFile.ModuleInfo.RequireInfo require : module.requires()) {
            tmp.writeShort(this.pool.moduleInfo(require.moduleName()));
            tmp.writeShort(require.flags());
            tmp.writeShort(require.version() != null ? this.pool.utf8(require.version()) : 0);
        }
        tmp.writeShort(module.exports().size());
        for (ClassFile.ModuleInfo.ExportInfo export : module.exports()) {
            tmp.writeShort(this.pool.packageInfo(export.moduleName()));
            tmp.writeShort(export.flags());
            tmp.writeShort(export.modules().size());
            for (String exportedModule : export.modules()) {
                tmp.writeShort(this.pool.moduleInfo(exportedModule));
            }
        }
        tmp.writeShort(module.opens().size());
        for (ClassFile.ModuleInfo.OpenInfo opens : module.opens()) {
            tmp.writeShort(this.pool.packageInfo(opens.moduleName()));
            tmp.writeShort(opens.flags());
            tmp.writeShort(opens.modules().size());
            for (String openModule : opens.modules()) {
                tmp.writeShort(this.pool.moduleInfo(openModule));
            }
        }
        tmp.writeShort(module.uses().size());
        for (ClassFile.ModuleInfo.UseInfo use : module.uses()) {
            tmp.writeShort(this.pool.classInfo(use.descriptor()));
        }
        tmp.writeShort(module.provides().size());
        for (ClassFile.ModuleInfo.ProvideInfo provide : module.provides()) {
            tmp.writeShort(this.pool.classInfo(provide.descriptor()));
            tmp.writeShort(provide.implDescriptors().size());
            for (String impl : provide.implDescriptors()) {
                tmp.writeShort(this.pool.classInfo(impl));
            }
        }
        byte[] data = tmp.toByteArray();
        this.output.writeShort(this.pool.utf8(attribute.kind().signature()));
        this.output.writeInt(data.length);
        this.output.write(data);
    }
}

