"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

var _relayRuntime = require("relay-runtime");

var _helpers = require("../helpers");

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/addPrReviewMutation.graphql");

  if (node.hash && node.hash !== "d2960bba4729b6c3e91e249ea582fec1") {
    console.error("The definition of 'addPrReviewMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/addPrReviewMutation.graphql");
};

let placeholderID = 0;

var _default = (environment, {
  body,
  event,
  pullRequestID,
  viewerID
}) => {
  const variables = {
    input: {
      pullRequestId: pullRequestID
    }
  };

  if (body) {
    variables.input.body = body;
  }

  if (event) {
    variables.input.event = event;
  }

  const configs = [{
    type: 'RANGE_ADD',
    parentID: pullRequestID,
    connectionInfo: [{
      key: 'ReviewSummariesAccumulator_reviews',
      rangeBehavior: 'append'
    }],
    edgeName: 'reviewEdge'
  }];

  function optimisticUpdater(store) {
    const pullRequest = store.get(pullRequestID);

    if (!pullRequest) {
      return;
    }

    const id = `add-pr-review:review:${placeholderID++}`;
    const review = store.create(id, 'PullRequestReview');
    review.setValue(id, 'id');
    review.setValue('PENDING', 'state');
    review.setValue(body, 'body');
    review.setValue(body ? (0, _helpers.renderMarkdown)(body) : '...', 'bodyHTML');
    review.setLinkedRecords([], 'reactionGroups');
    review.setValue(false, 'viewerCanReact');
    review.setValue(false, 'viewerCanUpdate');
    let author;

    if (viewerID) {
      author = store.get(viewerID);
    } else {
      author = store.create(`add-pr-review-comment:author:${placeholderID++}`, 'User');
      author.setValue('...', 'login');
      author.setValue('atom://github/img/avatar.svg', 'avatarUrl');
    }

    review.setLinkedRecord(author, 'author');

    const reviews = _relayRuntime.ConnectionHandler.getConnection(pullRequest, 'ReviewSummariesAccumulator_reviews');

    const edge = _relayRuntime.ConnectionHandler.createEdge(store, reviews, review, 'PullRequestReviewEdge');

    _relayRuntime.ConnectionHandler.insertEdgeAfter(reviews, edge);
  }

  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      configs,
      optimisticUpdater,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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