"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * The working directory exists, but contains no git repository yet.
 */
class Empty extends _state["default"] {
  isEmpty() {
    return true;
  }

  init() {
    return this.transitionTo('Initializing');
  }

  clone(remoteUrl) {
    return this.transitionTo('Cloning', remoteUrl);
  }

  showGitTabInit() {
    return true;
  }

}

exports["default"] = Empty;

_state["default"].register(Empty);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVtcHR5LmpzIl0sIm5hbWVzIjpbIkVtcHR5IiwiU3RhdGUiLCJpc0VtcHR5IiwiaW5pdCIsInRyYW5zaXRpb25UbyIsImNsb25lIiwicmVtb3RlVXJsIiwic2hvd0dpdFRhYkluaXQiLCJyZWdpc3RlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOzs7O0FBRUE7OztBQUdlLE1BQU1BLEtBQU4sU0FBb0JDLGlCQUFwQixDQUEwQjtBQUN2Q0MsRUFBQUEsT0FBTyxHQUFHO0FBQ1IsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLElBQUksR0FBRztBQUNMLFdBQU8sS0FBS0MsWUFBTCxDQUFrQixjQUFsQixDQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLEtBQUssQ0FBQ0MsU0FBRCxFQUFZO0FBQ2YsV0FBTyxLQUFLRixZQUFMLENBQWtCLFNBQWxCLEVBQTZCRSxTQUE3QixDQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLGNBQWMsR0FBRztBQUNmLFdBQU8sSUFBUDtBQUNEOztBQWZzQzs7OztBQWtCekNOLGtCQUFNTyxRQUFOLENBQWVSLEtBQWYiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS40MS4wL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBTdGF0ZSBmcm9tICcuL3N0YXRlJztcblxuLyoqXG4gKiBUaGUgd29ya2luZyBkaXJlY3RvcnkgZXhpc3RzLCBidXQgY29udGFpbnMgbm8gZ2l0IHJlcG9zaXRvcnkgeWV0LlxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBFbXB0eSBleHRlbmRzIFN0YXRlIHtcbiAgaXNFbXB0eSgpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIGluaXQoKSB7XG4gICAgcmV0dXJuIHRoaXMudHJhbnNpdGlvblRvKCdJbml0aWFsaXppbmcnKTtcbiAgfVxuXG4gIGNsb25lKHJlbW90ZVVybCkge1xuICAgIHJldHVybiB0aGlzLnRyYW5zaXRpb25UbygnQ2xvbmluZycsIHJlbW90ZVVybCk7XG4gIH1cblxuICBzaG93R2l0VGFiSW5pdCgpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxufVxuXG5TdGF0ZS5yZWdpc3RlcihFbXB0eSk7XG4iXX0=