"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareIssueishDetailController = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _issueDetailView = _interopRequireDefault(require("../views/issue-detail-view"));

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _reviewsItem = _interopRequireDefault(require("../items/reviews-item"));

var _reporterProxy = require("../reporter-proxy");

var _prCheckoutController = _interopRequireDefault(require("./pr-checkout-controller"));

var _prDetailView = _interopRequireDefault(require("../views/pr-detail-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareIssueishDetailController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "openCommit", async ({
      sha
    }) => {
      /* istanbul ignore if */
      if (!this.props.workdirPath) {
        return;
      }

      const uri = _commitDetailItem["default"].buildURI(this.props.workdirPath, sha);

      await this.props.workspace.open(uri, {
        pending: true
      });
      (0, _reporterProxy.addEvent)('open-commit-in-pane', {
        "package": 'github',
        from: this.constructor.name
      });
    });

    _defineProperty(this, "openReviews", async () => {
      /* istanbul ignore if */
      if (this.getTypename() !== 'PullRequest') {
        return;
      }

      const uri = _reviewsItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.repository.owner.login,
        repo: this.props.repository.name,
        number: this.props.issueishNumber,
        workdir: this.props.workdirPath
      });

      await this.props.workspace.open(uri);
      (0, _reporterProxy.addEvent)('open-reviews-tab', {
        "package": 'github',
        from: this.constructor.name
      });
    });
  }

  componentDidMount() {
    this.updateTitle();
  }

  componentDidUpdate() {
    this.updateTitle();
  }

  updateTitle() {
    const {
      repository
    } = this.props;

    if (repository && (repository.issue || repository.pullRequest)) {
      let prefix, issueish;

      if (this.getTypename() === 'PullRequest') {
        prefix = 'PR:';
        issueish = repository.pullRequest;
      } else {
        prefix = 'Issue:';
        issueish = repository.issue;
      }

      const title = `${prefix} ${repository.owner.login}/${repository.name}#${issueish.number} — ${issueish.title}`;
      this.props.onTitleChange(title);
    }
  }

  render() {
    const {
      repository
    } = this.props;

    if (!repository || !repository.issue || !repository.pullRequest) {
      return _react["default"].createElement("div", null, "Issue/PR #", this.props.issueishNumber, " not found"); // TODO: no PRs
    }

    if (this.getTypename() === 'PullRequest') {
      return _react["default"].createElement(_prCheckoutController["default"], {
        repository: repository,
        pullRequest: repository.pullRequest,
        localRepository: this.props.localRepository,
        isAbsent: this.props.isAbsent,
        isLoading: this.props.isLoading,
        isPresent: this.props.isPresent,
        isMerging: this.props.isMerging,
        isRebasing: this.props.isRebasing,
        branches: this.props.branches,
        remotes: this.props.remotes
      }, checkoutOp => _react["default"].createElement(_prDetailView["default"], {
        relay: this.props.relay,
        repository: this.props.repository,
        pullRequest: this.props.repository.pullRequest,
        checkoutOp: checkoutOp,
        localRepository: this.props.localRepository,
        reviewCommentsLoading: this.props.reviewCommentsLoading,
        reviewCommentsTotalCount: this.props.reviewCommentsTotalCount,
        reviewCommentsResolvedCount: this.props.reviewCommentsResolvedCount,
        reviewCommentThreads: this.props.reviewCommentThreads,
        endpoint: this.props.endpoint,
        token: this.props.token,
        workspace: this.props.workspace,
        commands: this.props.commands,
        keymaps: this.props.keymaps,
        tooltips: this.props.tooltips,
        config: this.props.config,
        openCommit: this.openCommit,
        openReviews: this.openReviews,
        switchToIssueish: this.props.switchToIssueish,
        destroy: this.props.destroy,
        reportRelayError: this.props.reportRelayError,
        itemType: this.props.itemType,
        refEditor: this.props.refEditor,
        initChangedFilePath: this.props.initChangedFilePath,
        initChangedFilePosition: this.props.initChangedFilePosition,
        selectedTab: this.props.selectedTab,
        onTabSelected: this.props.onTabSelected,
        onOpenFilesTab: this.props.onOpenFilesTab,
        workdirPath: this.props.workdirPath
      }));
    } else {
      return _react["default"].createElement(_issueDetailView["default"], {
        repository: repository,
        issue: repository.issue,
        switchToIssueish: this.props.switchToIssueish,
        tooltips: this.props.tooltips,
        reportRelayError: this.props.reportRelayError
      });
    }
  }

  getTypename() {
    const {
      repository
    } = this.props;
    /* istanbul ignore if */

    if (!repository) {
      return null;
    }
    /* istanbul ignore if */


    if (!repository.pullRequest) {
      return null;
    }

    return repository.pullRequest.__typename;
  }

}

exports.BareIssueishDetailController = BareIssueishDetailController;

_defineProperty(BareIssueishDetailController, "propTypes", {
  // Relay response
  relay: _propTypes["default"].object.isRequired,
  repository: _propTypes["default"].shape({
    name: _propTypes["default"].string.isRequired,
    owner: _propTypes["default"].shape({
      login: _propTypes["default"].string.isRequired
    }).isRequired,
    pullRequest: _propTypes["default"].any,
    issue: _propTypes["default"].any
  }),
  // Local Repository model properties
  localRepository: _propTypes["default"].object.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  isMerging: _propTypes["default"].bool.isRequired,
  isRebasing: _propTypes["default"].bool.isRequired,
  isAbsent: _propTypes["default"].bool.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  isPresent: _propTypes["default"].bool.isRequired,
  workdirPath: _propTypes["default"].string,
  issueishNumber: _propTypes["default"].number.isRequired,
  // Review comment threads
  reviewCommentsLoading: _propTypes["default"].bool.isRequired,
  reviewCommentsTotalCount: _propTypes["default"].number.isRequired,
  reviewCommentsResolvedCount: _propTypes["default"].number.isRequired,
  reviewCommentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })).isRequired,
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  // Action methods
  onTitleChange: _propTypes["default"].func.isRequired,
  switchToIssueish: _propTypes["default"].func.isRequired,
  destroy: _propTypes["default"].func.isRequired,
  reportRelayError: _propTypes["default"].func.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  refEditor: _propTypes2.RefHolderPropType.isRequired,
  // For opening files changed tab
  initChangedFilePath: _propTypes["default"].string,
  initChangedFilePosition: _propTypes["default"].number,
  selectedTab: _propTypes["default"].number.isRequired,
  onTabSelected: _propTypes["default"].func.isRequired,
  onOpenFilesTab: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueishDetailController, {
  repository: function () {
    const node = require("./__generated__/issueishDetailController_repository.graphql");

    if (node.hash && node.hash !== "504a7b23eb6c4c87798663e4d9c7136a") {
      console.error("The definition of 'issueishDetailController_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueishDetailController_repository.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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