/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.InitializationException;
import com.zeroc.Ice.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoggerI
implements Logger {
    String _prefix = "";
    String _formattedPrefix = "";
    String _file = "";
    String _lineSeparator;
    DateFormat _date;
    SimpleDateFormat _time;
    FileOutputStream _out = null;

    public LoggerI(String prefix, String file) {
        this._prefix = prefix;
        if (prefix.length() > 0) {
            this._formattedPrefix = prefix + ": ";
        }
        this._lineSeparator = System.getProperty("line.separator");
        this._date = DateFormat.getDateInstance(3);
        this._time = new SimpleDateFormat(" HH:mm:ss:SSS");
        if (file.length() != 0) {
            this._file = file;
            try {
                this._out = new FileOutputStream(new File(this._file), true);
            }
            catch (FileNotFoundException ex) {
                throw new InitializationException("FileLogger: cannot open " + this._file);
            }
        }
    }

    @Override
    public void print(String message) {
        StringBuilder s = new StringBuilder(256);
        s.append(message);
        this.write(s, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trace(String category, String message) {
        StringBuilder s = new StringBuilder(256);
        s.append("-- ");
        LoggerI loggerI = this;
        synchronized (loggerI) {
            Date date = new Date();
            s.append(this._date.format(date));
            s.append(this._time.format(date));
        }
        s.append(' ');
        s.append(this._formattedPrefix);
        s.append(category);
        s.append(": ");
        s.append(message);
        this.write(s, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warning(String message) {
        StringBuilder s = new StringBuilder(256);
        s.append("-! ");
        LoggerI loggerI = this;
        synchronized (loggerI) {
            s.append(this._date.format(new Date()));
            s.append(this._time.format(new Date()));
        }
        s.append(' ');
        s.append(this._formattedPrefix);
        s.append("warning: ");
        s.append(Thread.currentThread().getName());
        s.append(": ");
        s.append(message);
        this.write(s, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(String message) {
        StringBuilder s = new StringBuilder(256);
        s.append("!! ");
        LoggerI loggerI = this;
        synchronized (loggerI) {
            s.append(this._date.format(new Date()));
            s.append(this._time.format(new Date()));
        }
        s.append(' ');
        s.append(this._formattedPrefix);
        s.append("error: ");
        s.append(Thread.currentThread().getName());
        s.append(": ");
        s.append(message);
        this.write(s, true);
    }

    @Override
    public String getPrefix() {
        return this._prefix;
    }

    @Override
    public Logger cloneWithPrefix(String prefix) {
        return new LoggerI(prefix, this._file);
    }

    private void write(StringBuilder message, boolean indent) {
        if (indent) {
            int idx = 0;
            while ((idx = message.indexOf("\n", idx)) != -1) {
                message.insert(idx + 1, "   ");
                ++idx;
            }
        }
        message.append(this._lineSeparator);
        if (this._out == null) {
            System.err.print(message.toString());
        } else {
            try {
                this._out.write(message.toString().getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void destroy() {
        if (this._file.length() > 0) {
            try {
                this._out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

