/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.DirectBufferWrapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.Nullable;

public class ReadWriteDirectBufferWrapper
extends DirectBufferWrapper {
    private static final Logger LOG = Logger.getInstance(ReadWriteDirectBufferWrapper.class);
    private static final String RW = "rw";

    protected ReadWriteDirectBufferWrapper(File file, long offset, long length) {
        super(file, offset, length);
        assert (length <= Integer.MAX_VALUE) : length;
    }

    @Override
    protected ByteBuffer create() throws IOException {
        try (FileContext context = new FileContext(this.myFile);){
            RandomAccessFile file = context.file;
            assert (file != null);
            FileChannel channel = file.getChannel();
            channel.position(this.myPosition);
            ByteBuffer buffer = ByteBuffer.allocateDirect((int)this.myLength);
            channel.read(buffer);
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    FileContext flushWithContext(@Nullable FileContext fileContext) {
        ByteBuffer buffer = this.getCachedBuffer();
        if (buffer != null && this.isDirty()) {
            try {
                if (fileContext == null) {
                    fileContext = new FileContext(this.myFile);
                }
                this.doFlush(fileContext, buffer);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
        return fileContext;
    }

    private void doFlush(FileContext fileContext, ByteBuffer buffer) throws IOException {
        RandomAccessFile file = fileContext.file;
        assert (file != null);
        FileChannel channel = file.getChannel();
        channel.position(this.myPosition);
        buffer.rewind();
        channel.write(buffer);
        this.myDirty = false;
    }

    @Override
    public void flush() {
        ByteBuffer buffer = this.getCachedBuffer();
        if (buffer != null && this.isDirty()) {
            try (FileContext context = new FileContext(this.myFile);){
                this.doFlush(context, buffer);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    static class FileContext
    implements AutoCloseable {
        final RandomAccessFile file;

        FileContext(final File path) throws IOException {
            this.file = FileUtilRt.doIOOperation(new FileUtilRt.RepeatableIOOperation<RandomAccessFile, IOException>(){
                boolean parentWasCreated;

                @Override
                @Nullable
                public RandomAccessFile execute(boolean finalAttempt) throws IOException {
                    try {
                        return new RandomAccessFile(path, ReadWriteDirectBufferWrapper.RW);
                    }
                    catch (FileNotFoundException ex) {
                        File parentFile = path.getParentFile();
                        if (!parentFile.exists()) {
                            if (!this.parentWasCreated) {
                                FileUtil.createDirectory(parentFile);
                                this.parentWasCreated = true;
                            } else {
                                throw new IOException("Parent directory still doesn't exist: " + path);
                            }
                        }
                        if (!finalAttempt) {
                            return null;
                        }
                        throw ex;
                    }
                }
            });
        }

        @Override
        public void close() {
            try {
                if (this.file != null) {
                    this.file.close();
                }
            }
            catch (IOException ex) {
                LOG.error(ex);
            }
        }
    }
}

