/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.PathUtilRt;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultVcsRootPolicy {
    @NotNull
    protected final Project myProject;

    protected DefaultVcsRootPolicy(@NotNull Project project) {
        if (project == null) {
            DefaultVcsRootPolicy.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public static DefaultVcsRootPolicy getInstance(Project project) {
        return (DefaultVcsRootPolicy)ServiceManager.getService((Project)project, DefaultVcsRootPolicy.class);
    }

    @NotNull
    public abstract Collection<VirtualFile> getDefaultVcsRoots();

    public String getProjectConfigurationMessage() {
        boolean isDirectoryBased = ProjectKt.isDirectoryBased((Project)this.myProject);
        StringBuilder sb = new StringBuilder("Content roots of all modules");
        if (isDirectoryBased) {
            sb.append(", ");
        } else {
            sb.append(", and ");
        }
        sb.append("all immediate descendants of project base directory");
        if (isDirectoryBased) {
            sb.append(", and ");
            sb.append(PathUtilRt.getFileName((String)ProjectKt.getStateStore((Project)this.myProject).getDirectoryStorePath()));
            sb.append(" directory contents");
        }
        return sb.toString();
    }

    protected void scheduleMappedRootsUpdate() {
        ProjectLevelVcsManagerEx vcsManager = ProjectLevelVcsManagerEx.getInstanceEx(this.myProject);
        if (StringUtil.isNotEmpty((String)vcsManager.haveDefaultMapping())) {
            vcsManager.scheduleMappedRootsUpdate();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/DefaultVcsRootPolicy", "<init>"));
    }
}

