/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.Function;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromiseKt$sam$java_util_function_Function$0;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.InternalPromiseUtil;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u001d\b\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\n\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u000f\u0010\u0014\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J \u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J \u0010\u001d\u001a\u0004\u0018\u00018\u00002\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001fH\u0082\b\u00a2\u0006\u0002\u0010 J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u000e\u0010#\u001a\n\u0012\u0006\b\u0000\u0012\u00020%0$H\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u000e\u0010'\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000$H\u0016J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u000e\u0010)\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000$H\u0016J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u000e\u0010*\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\"H\u0016J\u000e\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020-J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020%H\u0016J\u0017\u0010.\u001a\u00020\u00112\b\u0010/\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00100J,\u00101\u001a\b\u0012\u0004\u0012\u0002H20\"\"\u0004\b\u0001\u001022\u0016\u00103\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u0002H204H\u0016J2\u00105\u001a\b\u0012\u0004\u0012\u0002H20\"\"\u0004\b\u0001\u001022\u001c\u00106\u001a\u0018\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H20\"04H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/concurrency/AsyncPromise;", "T", "Lorg/jetbrains/concurrency/CancellablePromise;", "Lorg/jetbrains/concurrency/InternalPromiseUtil$CompletablePromise;", "()V", "f", "Ljava/util/concurrent/CompletableFuture;", "hasErrorHandler", "Ljava/util/concurrent/atomic/AtomicBoolean;", "(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/atomic/AtomicBoolean;)V", "blockingGet", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(ILjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "cancel", "", "", "mayInterruptIfRunning", "get", "()Ljava/lang/Object;", "", "unit", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getState", "Lorg/jetbrains/concurrency/Promise$State;", "isCancelled", "isDone", "nullizeCancelled", "value", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "onError", "Lorg/jetbrains/concurrency/Promise;", "rejected", "Ljava/util/function/Consumer;", "", "onProcessed", "processed", "onSuccess", "handler", "child", "setError", "error", "", "setResult", "t", "(Ljava/lang/Object;)V", "then", "SUB_RESULT", "done", "Lcom/intellij/util/Function;", "thenAsync", "doneF", "intellij.platform.concurrency"})
public class AsyncPromise<T>
implements CancellablePromise<T>,
InternalPromiseUtil.CompletablePromise<T> {
    private final CompletableFuture<T> f;
    private final AtomicBoolean hasErrorHandler;

    public boolean isDone() {
        return this.f.isDone();
    }

    @Nullable
    public T get() {
        Object v0;
        AsyncPromise this_$iv = this;
        boolean $i$f$nullizeCancelled = false;
        if (this_$iv.isCancelled()) {
            v0 = null;
        } else {
            Object var4_5;
            try {
                boolean bl = false;
                var4_5 = this.f.get();
            }
            catch (CancellationException e$iv) {
                var4_5 = null;
            }
            v0 = var4_5;
        }
        return v0;
    }

    @Nullable
    public T get(long timeout, @NotNull TimeUnit unit) {
        Object v0;
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        AsyncPromise this_$iv = this;
        boolean $i$f$nullizeCancelled = false;
        if (this_$iv.isCancelled()) {
            v0 = null;
        } else {
            Object var7_6;
            try {
                boolean bl = false;
                var7_6 = this.f.get(timeout, unit);
            }
            catch (CancellationException e$iv) {
                var7_6 = null;
            }
            v0 = var7_6;
        }
        return v0;
    }

    private final T nullizeCancelled(Function0<? extends T> value) {
        Object object;
        int $i$f$nullizeCancelled = 0;
        if (this.isCancelled()) {
            return null;
        }
        try {
            object = value.invoke();
        }
        catch (CancellationException e) {
            object = null;
        }
        return (T)object;
    }

    public boolean isCancelled() {
        return this.f.isCancelled();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return !this.isCancelled() && this.f.cancel(mayInterruptIfRunning);
    }

    public void cancel() {
        this.cancel(true);
    }

    @NotNull
    public Promise.State getState() {
        return !this.f.isDone() ? Promise.State.PENDING : (this.f.isCompletedExceptionally() ? Promise.State.REJECTED : Promise.State.SUCCEEDED);
    }

    @NotNull
    public Promise<T> onSuccess(@NotNull Consumer<? super T> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        CompletionStage completionStage = this.f.whenComplete(new BiConsumer<T, Throwable>(handler){
            final /* synthetic */ Consumer $handler;

            public final void accept(T value, Throwable exception) {
                block3: {
                    if (exception == null && !InternalPromiseUtil.isHandlerObsolete(this.$handler)) {
                        try {
                            this.$handler.accept(value);
                        }
                        catch (Throwable e) {
                            if (e instanceof ControlFlowException) break block3;
                            Logger.getInstance(AsyncPromise.class).error(e);
                        }
                    }
                }
            }
            {
                this.$handler = consumer;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"f.whenComplete { value, \u2026}\n        }\n      }\n    }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler);
    }

    @NotNull
    public Promise<T> onError(@NotNull Consumer<? super Throwable> rejected2) {
        Intrinsics.checkParameterIsNotNull(rejected2, (String)"rejected");
        this.hasErrorHandler.set(true);
        CompletionStage completionStage = this.f.whenComplete(new BiConsumer<T, Throwable>(rejected2){
            final /* synthetic */ Consumer $rejected;

            public final void accept(T $noName_0, Throwable exception) {
                if (exception != null) {
                    Throwable toReport;
                    Throwable throwable;
                    if (exception instanceof CompletionException && exception.getCause() != null) {
                        throwable = exception.getCause();
                        if (throwable == null) {
                            Intrinsics.throwNpe();
                        }
                    } else {
                        throwable = toReport = exception;
                    }
                    if (!InternalPromiseUtil.isHandlerObsolete(this.$rejected)) {
                        this.$rejected.accept(toReport);
                    }
                }
            }
            {
                this.$rejected = consumer;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"f.whenComplete { _, exce\u2026)\n        }\n      }\n    }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler);
    }

    @NotNull
    public Promise<T> onProcessed(@NotNull Consumer<? super T> processed2) {
        Intrinsics.checkParameterIsNotNull(processed2, (String)"processed");
        this.hasErrorHandler.set(true);
        CompletionStage completionStage = this.f.whenComplete(new BiConsumer<T, Throwable>(processed2){
            final /* synthetic */ Consumer $processed;

            public final void accept(T value, Throwable $noName_1) {
                if (!InternalPromiseUtil.isHandlerObsolete(this.$processed)) {
                    this.$processed.accept(value);
                }
            }
            {
                this.$processed = consumer;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"f.whenComplete { value, \u2026cept(value)\n      }\n    }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler);
    }

    @Nullable
    public T blockingGet(int timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        try {
            return this.get(timeout, timeUnit);
        }
        catch (ExecutionException e) {
            if (e.getCause() == InternalPromiseUtil.OBSOLETE_ERROR) {
                return null;
            }
            ExceptionUtilRt.rethrowUnchecked((Throwable)e.getCause());
            throw (Throwable)e;
        }
    }

    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done2) {
        Intrinsics.checkParameterIsNotNull(done2, (String)"done");
        CompletionStage completionStage = this.f.thenApply(new java.util.function.Function<T, U>(done2){
            final /* synthetic */ Function $done;

            public final SUB_RESULT apply(T it) {
                return (SUB_RESULT)this.$done.fun(it);
            }
            {
                this.$done = function;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"f.thenApply { done.`fun`(it) }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler);
    }

    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, ? extends Promise<SUB_RESULT>> doneF) {
        Function1 convert2;
        Intrinsics.checkParameterIsNotNull(doneF, (String)"doneF");
        Function1 function1 = convert2 = (Function1)new Function1<T, CompletableFuture<SUB_RESULT>>(doneF){
            final /* synthetic */ Function $doneF;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CompletableFuture<SUB_RESULT> invoke(T it) {
                void var3_3;
                Promise promise = (Promise)this.$doneF.fun(it);
                CompletableFuture<T> future = new CompletableFuture<T>();
                promise.onSuccess((Consumer)new Consumer<SUB_RESULT>(future){
                    final /* synthetic */ CompletableFuture $future;

                    public final void accept(SUB_RESULT value) {
                        this.$future.complete(value);
                    }
                    {
                        this.$future = completableFuture;
                    }
                }).onError((Consumer)new Consumer<Throwable>(future){
                    final /* synthetic */ CompletableFuture $future;

                    public final void accept(Throwable error) {
                        this.$future.completeExceptionally(error);
                    }
                    {
                        this.$future = completableFuture;
                    }
                });
                return var3_3;
            }
            {
                this.$doneF = function;
                super(1);
            }
        };
        CompletionStage completionStage = this.f.thenCompose((java.util.function.Function)new AsyncPromiseKt$sam$java_util_function_Function$0(function1));
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"f.thenCompose(convert)");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler);
    }

    @NotNull
    public Promise<T> processed(@NotNull Promise<? super T> child) {
        Intrinsics.checkParameterIsNotNull(child, (String)"child");
        if (!(child instanceof AsyncPromise)) {
            return this;
        }
        Promise promise = this.onSuccess(new Consumer<T>(child){
            final /* synthetic */ Promise $child;

            public final void accept(T it) {
                ((AsyncPromise)this.$child).setResult(it);
            }
            {
                this.$child = promise;
            }
        }).onError((Consumer)new Consumer<Throwable>(child){
            final /* synthetic */ Promise $child;

            public final void accept(Throwable it) {
                AsyncPromise asyncPromise = (AsyncPromise)this.$child;
                Throwable throwable = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                asyncPromise.setError(throwable);
            }
            {
                this.$child = promise;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"onSuccess { child.setRes\u2026or { child.setError(it) }");
        return promise;
    }

    @Override
    public void setResult(@Nullable T t) {
        this.f.complete(t);
    }

    @Override
    public boolean setError(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        if (!this.f.completeExceptionally(error)) {
            return false;
        }
        if (!this.hasErrorHandler.get()) {
            Logger logger = Logger.getInstance(AsyncPromise.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(AsyncPromise::class.java)");
            Promises.errorIfNotMessage(logger, error);
        }
        return true;
    }

    public final boolean setError(@NotNull String error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        return this.setError(Promises.createError$default(error, false, 2, null));
    }

    private AsyncPromise(CompletableFuture<T> f, AtomicBoolean hasErrorHandler) {
        this.f = f;
        this.hasErrorHandler = hasErrorHandler;
    }

    public AsyncPromise() {
        this(new CompletableFuture(), new AtomicBoolean());
    }
}

