/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.TestDiscoveryBasicListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;

public class InternalTestDiscoveryListener
extends TestDiscoveryBasicListener
implements Closeable {
    private final String myModuleName;
    private final String myTracesFile = System.getProperty("org.jetbrains.instrumentation.trace.file");
    private Object myDiscoveryIndex;
    private Class<?> myDiscoveryIndexClass;

    public InternalTestDiscoveryListener() {
        if (this.myTracesFile == null) {
            throw new IllegalArgumentException();
        }
        this.myModuleName = System.getProperty("org.jetbrains.instrumentation.main.module");
        if (this.myModuleName == null) {
            throw new IllegalArgumentException();
        }
        System.out.println(this.getClass().getSimpleName() + " instantiated with module='" + this.myModuleName + "' , directory='" + this.myTracesFile + "'");
    }

    private Object getIndex() {
        if (this.myDiscoveryIndex == null) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            try {
                this.myDiscoveryIndexClass = Class.forName("com.intellij.execution.testDiscovery.TestDiscoveryIndex");
                this.myDiscoveryIndex = this.myDiscoveryIndexClass.getConstructor(Project.class, String.class).newInstance(project2, this.myTracesFile);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.myDiscoveryIndex;
    }

    @Override
    public void close() throws IOException {
        System.out.println("Start compacting to index");
        try {
            Object index = this.getIndex();
            Method method = Class.forName("com.intellij.execution.testDiscovery.TestDiscoveryExtension").getMethod("processTracesFile", String.class, String.class, String.class, this.myDiscoveryIndexClass);
            method.invoke(null, this.myTracesFile, this.myModuleName, "j", index);
            System.out.println("Compacting done.");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        InternalTestDiscoveryListener.zipOutput(this.myTracesFile);
    }

    private static void zipOutput(String traceFilePath) {
        File traceFile = new File(traceFilePath);
        File parent = traceFile.getParentFile();
        String zipName = traceFile.getName() + ".zip";
        System.out.println("Preparing zip.");
        try {
            File zipFile = new File(parent, zipName);
            ZipUtil.compressFile((File)traceFile, (File)zipFile);
            FileUtil.delete((File)traceFile);
            System.out.println("archive " + zipFile.getPath() + " prepared");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

