/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.branch.DvcsBranchPopup;
import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.dvcs.ui.RootAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBranchPopup
extends DvcsBranchPopup<GitRepository> {
    private static final String DIMENSION_SERVICE_KEY = "Git.Branch.Popup";
    static final String SHOW_ALL_LOCALS_KEY = "Git.Branch.Popup.ShowAllLocals";
    static final String SHOW_ALL_REMOTES_KEY = "Git.Branch.Popup.ShowAllRemotes";
    static final String SHOW_ALL_REPOSITORIES = "Git.Branch.Popup.ShowAllRepositories";

    static GitBranchPopup getInstance(@NotNull Project project, @NotNull GitRepository currentRepository) {
        if (project == null) {
            GitBranchPopup.$$$reportNull$$$0(0);
        }
        if (currentRepository == null) {
            GitBranchPopup.$$$reportNull$$$0(1);
        }
        GitVcsSettings vcsSettings = GitVcsSettings.getInstance(project);
        Condition preselectActionCondition = action -> {
            GitBranchPopupActions.LocalBranchActions branchAction = GitBranchPopup.getBranchAction(action);
            if (branchAction != null) {
                String branchName = branchAction.getBranchName();
                List<GitRepository> repositories = branchAction.getRepositories();
                String recentBranch = repositories.size() == 1 ? vcsSettings.getRecentBranchesByRepository().get(repositories.iterator().next().getRoot().getPath()) : vcsSettings.getRecentCommonBranch();
                if (recentBranch != null && recentBranch.equals(branchName)) {
                    return true;
                }
            }
            return false;
        };
        return new GitBranchPopup(currentRepository, GitUtil.getRepositoryManager(project), vcsSettings, (Condition<AnAction>)preselectActionCondition);
    }

    @Nullable
    private static GitBranchPopupActions.LocalBranchActions getBranchAction(@NotNull AnAction action) {
        if (action == null) {
            GitBranchPopup.$$$reportNull$$$0(2);
        }
        AnAction resultAction = action instanceof EmptyAction.MyDelegatingActionGroup ? ((EmptyAction.MyDelegatingActionGroup)action).getDelegate() : action;
        return (GitBranchPopupActions.LocalBranchActions)((Object)ObjectUtils.tryCast((Object)resultAction, GitBranchPopupActions.LocalBranchActions.class));
    }

    private GitBranchPopup(@NotNull GitRepository currentRepository, @NotNull GitRepositoryManager repositoryManager, @NotNull GitVcsSettings vcsSettings, @NotNull Condition<AnAction> preselectActionCondition) {
        if (currentRepository == null) {
            GitBranchPopup.$$$reportNull$$$0(3);
        }
        if (repositoryManager == null) {
            GitBranchPopup.$$$reportNull$$$0(4);
        }
        if (vcsSettings == null) {
            GitBranchPopup.$$$reportNull$$$0(5);
        }
        if (preselectActionCondition == null) {
            GitBranchPopup.$$$reportNull$$$0(6);
        }
        super((Repository)currentRepository, (AbstractRepositoryManager)repositoryManager, (DvcsMultiRootBranchConfig)new GitMultiRootBranchConfig(repositoryManager.getRepositories()), (DvcsSyncSettings)vcsSettings, preselectActionCondition, DIMENSION_SERVICE_KEY);
        GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.myProject);
        if (gitBranchIncomingOutgoingManager.shouldCheckIncoming() && !gitBranchIncomingOutgoingManager.supportsIncomingOutgoing()) {
            this.myPopup.addToolbarAction(GitBranchPopup.createWarningAction("Update checks not supported. Git 2.9+ required", (Consumer<? super AnActionEvent>)((Consumer)e -> ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, "Git"))), false);
        } else if (gitBranchIncomingOutgoingManager.shouldCheckIncoming() && gitBranchIncomingOutgoingManager.hasAuthenticationProblems()) {
            this.myPopup.addToolbarAction(GitBranchPopup.createWarningAction("Update checks failed. Click to retry", (Consumer<? super AnActionEvent>)((Consumer)e -> {
                gitBranchIncomingOutgoingManager.forceUpdateBranchesToPull();
                this.myPopup.cancel();
            })), false);
        }
    }

    @NotNull
    private static AnAction createWarningAction(@NotNull String text, @NotNull Consumer<? super AnActionEvent> actionEventConsumer) {
        if (text == null) {
            GitBranchPopup.$$$reportNull$$$0(7);
        }
        if (actionEventConsumer == null) {
            GitBranchPopup.$$$reportNull$$$0(8);
        }
        DumbAwareAction updateBranchInfoWithAuthenticationAction = DumbAwareAction.create((String)text, actionEventConsumer);
        Presentation presentation = updateBranchInfoWithAuthenticationAction.getTemplatePresentation();
        presentation.setIcon(AllIcons.General.Warning);
        presentation.setHoveredIcon(AllIcons.General.Warning);
        DumbAwareAction dumbAwareAction = updateBranchInfoWithAuthenticationAction;
        if (dumbAwareAction == null) {
            GitBranchPopup.$$$reportNull$$$0(9);
        }
        return dumbAwareAction;
    }

    protected void fillWithCommonRepositoryActions(@NotNull LightActionGroup popupGroup, @NotNull AbstractRepositoryManager<GitRepository> repositoryManager) {
        if (popupGroup == null) {
            GitBranchPopup.$$$reportNull$$$0(10);
        }
        if (repositoryManager == null) {
            GitBranchPopup.$$$reportNull$$$0(11);
        }
        List allRepositories = repositoryManager.getRepositories();
        GitRebaseSpec rebaseSpec = GitUtil.getRepositoryManager(this.myProject).getOngoingRebaseSpec();
        if (rebaseSpec != null && rebaseSpec.getAllRepositories().size() == allRepositories.size()) {
            popupGroup.addAll(GitBranchPopupActions.getRebaseActions());
        }
        popupGroup.add((AnAction)new GitBranchPopupActions.GitNewBranchAction(this.myProject, allRepositories));
        popupGroup.add((AnAction)new GitBranchPopupActions.CheckoutRevisionActions(this.myProject, allRepositories));
        popupGroup.addAll((ActionGroup)this.createRepositoriesActions());
        popupGroup.addSeparator("Common Local Branches");
        List localBranchActions = this.myMultiRootBranchConfig.getLocalBranchNames().stream().map(l -> this.createLocalBranchActions(allRepositories, (String)l)).filter(Objects::nonNull).sorted(BranchActionUtil.FAVORITE_BRANCH_COMPARATOR).collect(Collectors.toList());
        int topShownBranches = BranchActionUtil.getNumOfTopShownBranches(localBranchActions);
        String currentBranch = MultiRootBranches.getCommonCurrentBranch((Collection)allRepositories);
        if (currentBranch != null) {
            localBranchActions.add(0, new GitBranchPopupActions.CurrentBranchActions(this.myProject, allRepositories, currentBranch, (GitRepository)this.myCurrentRepository));
            ++topShownBranches;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, localBranchActions, (int)topShownBranches, (String)SHOW_ALL_LOCALS_KEY, (boolean)true);
        popupGroup.addSeparator("Common Remote Branches");
        List remoteBranchActions = ContainerUtil.map(((GitMultiRootBranchConfig)this.myMultiRootBranchConfig).getRemoteBranches(), remoteBranch -> new GitBranchPopupActions.RemoteBranchActions(this.myProject, allRepositories, (String)remoteBranch, (GitRepository)this.myCurrentRepository));
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)ContainerUtil.sorted((Collection)remoteBranchActions, (Comparator)BranchActionUtil.FAVORITE_BRANCH_COMPARATOR), (int)BranchActionUtil.getNumOfTopShownBranches((List)remoteBranchActions), (String)SHOW_ALL_REMOTES_KEY);
    }

    @Nullable
    private GitBranchPopupActions.LocalBranchActions createLocalBranchActions(@NotNull List<? extends GitRepository> allRepositories, @NotNull String branch) {
        List repositories;
        if (allRepositories == null) {
            GitBranchPopup.$$$reportNull$$$0(12);
        }
        if (branch == null) {
            GitBranchPopup.$$$reportNull$$$0(13);
        }
        return (repositories = this.filterRepositoriesNotOnThisBranch(branch, allRepositories)).isEmpty() ? null : new GitBranchPopupActions.LocalBranchActions(this.myProject, repositories, branch, (GitRepository)this.myCurrentRepository);
    }

    @NotNull
    protected LightActionGroup createRepositoriesActions() {
        LightActionGroup popupGroup = new LightActionGroup(false);
        popupGroup.addSeparator("Repositories");
        List rootActions = ContainerUtil.map((Collection)DvcsUtil.sortRepositories((Collection)this.myRepositoryManager.getRepositories()), repo -> new RootAction((Repository)repo, new GitBranchPopupActions(repo.getProject(), (GitRepository)repo).createActions(), GitBranchUtil.getDisplayableBranchText(repo)));
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)rootActions, (int)(rootActions.size() > 8 ? 5 : 8), (String)SHOW_ALL_REPOSITORIES);
        LightActionGroup lightActionGroup = popupGroup;
        if (lightActionGroup == null) {
            GitBranchPopup.$$$reportNull$$$0(14);
        }
        return lightActionGroup;
    }

    protected void fillPopupWithCurrentRepositoryActions(@NotNull LightActionGroup popupGroup, @Nullable LightActionGroup actions) {
        if (popupGroup == null) {
            GitBranchPopup.$$$reportNull$$$0(15);
        }
        popupGroup.addAll(new GitBranchPopupActions(((GitRepository)this.myCurrentRepository).getProject(), (GitRepository)this.myCurrentRepository).createActions(actions, this.myRepoTitleInfo, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRepository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preselectActionCondition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionEventConsumer";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitBranchPopup";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupGroup";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRepositories";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createWarningAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createRepositoriesActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBranchAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createWarningAction";
                break;
            }
            case 9: 
            case 14: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillWithCommonRepositoryActions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createLocalBranchActions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fillPopupWithCurrentRepositoryActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

