/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpCharRange;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepeatedSpaceInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Consecutive spaces" == null) {
            RepeatedSpaceInspection.$$$reportNull$$$0(0);
        }
        return "Consecutive spaces";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RepeatedSpaceInspection.$$$reportNull$$$0(1);
        }
        RepeatedSpaceVisitor repeatedSpaceVisitor = new RepeatedSpaceVisitor(holder);
        if (repeatedSpaceVisitor == null) {
            RepeatedSpaceInspection.$$$reportNull$$$0(2);
        }
        return repeatedSpaceVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RepeatedSpaceFix
    implements LocalQuickFix {
        private final int myCount;

        RepeatedSpaceFix(int count) {
            this.myCount = count;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with ' {" + this.myCount + "}'";
            if (string == null) {
                RepeatedSpaceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with space and repeated quantifier" == null) {
                RepeatedSpaceFix.$$$reportNull$$$0(1);
            }
            return "Replace with space and repeated quantifier";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                RepeatedSpaceFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                RepeatedSpaceFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor2.getPsiElement()) instanceof RegExpBranch)) {
                return;
            }
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element.getProject());
            TextRange range2 = descriptor2.getTextRangeInElement();
            StringBuilder text2 = new StringBuilder();
            boolean inserted = false;
            for (PsiElement child2 = element.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
                if (!range2.contains(child2.getStartOffsetInParent())) {
                    text2.append(injectedLanguageManager.getUnescapedText(child2));
                    continue;
                }
                if (inserted) continue;
                text2.append(" {").append(this.myCount).append('}');
                inserted = true;
            }
            RegExpReplacementUtil.replaceInContext(element, text2.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection$RepeatedSpaceFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection$RepeatedSpaceFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RepeatedSpaceVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        RepeatedSpaceVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar aChar) {
            if (!RepeatedSpaceVisitor.isSpace(aChar) || RepeatedSpaceVisitor.isSpace(aChar.getPrevSibling()) || RepeatedSpaceVisitor.isInEscapeSequence(aChar)) {
                return;
            }
            PsiElement parent = aChar.getParent();
            if (parent instanceof RegExpClass || parent instanceof RegExpCharRange) {
                return;
            }
            int count = 1;
            int length = aChar.getTextLength();
            PsiElement next = aChar.getNextSibling();
            while (RepeatedSpaceVisitor.isSpace(next)) {
                ++count;
                length += next.getTextLength();
                next = next.getNextSibling();
            }
            if (count > 1) {
                String message = count + " consecutive spaces in RegExp";
                int offset = aChar.getStartOffsetInParent();
                this.myHolder.registerProblem(parent, new TextRange(offset, offset + length), message, new LocalQuickFix[]{new RepeatedSpaceFix(count)});
            }
        }

        private static boolean isInEscapeSequence(RegExpChar aChar) {
            PsiElement prev = aChar.getPrevSibling();
            while (prev instanceof RegExpChar) {
                prev = prev.getPrevSibling();
            }
            if (RepeatedSpaceVisitor.isEscapeSequenceStart(prev)) {
                return true;
            }
            PsiElement parent = aChar.getParent();
            if (prev != null || !(parent instanceof RegExpBranch)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            return grandParent instanceof RegExpPattern && RepeatedSpaceVisitor.isEscapeSequenceStart(grandParent.getPrevSibling());
        }

        private static boolean isEscapeSequenceStart(@Nullable PsiElement element) {
            return element instanceof PsiWhiteSpace && "\\Q".equals(InjectedLanguageManager.getInstance((Project)element.getProject()).getUnescapedText(element));
        }

        private static boolean isSpace(PsiElement element) {
            if (!(element instanceof RegExpChar)) {
                return false;
            }
            RegExpChar aChar = (RegExpChar)element;
            return aChar.getType() == RegExpChar.Type.CHAR && aChar.getValue() == 32;
        }
    }
}

