/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexScanRunnableCollector;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBasedIndexProjectHandler
implements IndexableFileSet,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.FileBasedIndexProjectHandler");
    private final FileBasedIndex myIndex;
    private final FileBasedIndexScanRunnableCollector myCollector;
    @ApiStatus.Internal
    public static final int ourMinFilesToStartDumMode = Registry.intValue((String)"ide.dumb.mode.minFilesToStart", (int)20);
    private static final int ourMinFilesSizeToStartDumMode = Registry.intValue((String)"ide.dumb.mode.minFilesSizeToStart", (int)0x100000);

    public FileBasedIndexProjectHandler(final @NotNull Project project, FileBasedIndex index, FileBasedIndexScanRunnableCollector collector) {
        StartupManager startupManager;
        if (project == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(0);
        }
        this.myIndex = index;
        this.myCollector = collector;
        if (ApplicationManager.getApplication().isInternal()) {
            project.getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void exitDumbMode() {
                    LOG.info("Has changed files: " + (FileBasedIndexProjectHandler.createChangedFilesIndexingTask(project) != null) + "; project=" + project);
                }
            });
        }
        if ((startupManager = StartupManager.getInstance((Project)project)) != null) {
            startupManager.registerPreStartupActivity(() -> {
                PushedFilePropertiesUpdater.getInstance((Project)project).initializeProperties();
                TransactionGuard.submitTransaction((Disposable)project, () -> {
                    if (FileBasedIndex.getInstance() instanceof FileBasedIndexImpl) {
                        DumbService.getInstance((Project)project).queueTask((DumbModeTask)new UnindexedFilesUpdater(project));
                    }
                });
                this.myIndex.registerIndexableSet((IndexableFileSet)this, project);
                project.getMessageBus().connect((Disposable)this).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){
                    private boolean removed;

                    public void projectClosing(@NotNull Project eventProject) {
                        if (eventProject == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (eventProject == project && !this.removed) {
                            this.removed = true;
                            FileBasedIndexProjectHandler.this.myIndex.removeIndexableSet((IndexableFileSet)FileBasedIndexProjectHandler.this);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventProject", "com/intellij/util/indexing/FileBasedIndexProjectHandler$2", "projectClosing"));
                    }
                });
            });
        }
    }

    public boolean isInSet(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(1);
        }
        return this.myCollector.shouldCollect(file2);
    }

    public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator) {
        if (file2 == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(2);
        }
        if (iterator == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(3);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!FileBasedIndexProjectHandler.this.isInSet(file2)) {
                    return false;
                }
                iterator.processFile(file2);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexProjectHandler$3", "visitFile"));
            }
        });
    }

    public void dispose() {
        this.myIndex.removeIndexableSet((IndexableFileSet)this);
    }

    @Nullable
    public static DumbModeTask createChangedFilesIndexingTask(final Project project) {
        FileBasedIndex i = FileBasedIndex.getInstance();
        if (!(i instanceof FileBasedIndexImpl) || !IndexInfrastructure.hasIndices()) {
            return null;
        }
        final FileBasedIndexImpl index = (FileBasedIndexImpl)i;
        if (!FileBasedIndexProjectHandler.mightHaveManyChangedFilesInProject(project, index)) {
            return null;
        }
        return new DumbModeTask(project.getComponent(FileBasedIndexProjectHandler.class)){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                long start2 = System.currentTimeMillis();
                Collection<VirtualFile> files2 = index.getFilesToUpdate(project);
                long calcDuration = System.currentTimeMillis() - start2;
                indicator.setIndeterminate(false);
                indicator.setText(IdeBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
                LOG.info("Reindexing refreshed files: " + files2.size() + " to update, calculated in " + calcDuration + "ms");
                if (!files2.isEmpty()) {
                    PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
                    FileBasedIndexProjectHandler.reindexRefreshedFiles(indicator, files2, project, index);
                    snapshot.logResponsivenessSinceCreation("Reindexing refreshed files");
                }
            }

            public String toString() {
                final StringBuilder sampleOfChangedFilePathsToBeIndexed = new StringBuilder();
                index.processChangedFiles(project, (Processor<? super VirtualFile>)new Processor<VirtualFile>(){
                    int filesInProjectToBeIndexed;
                    final String projectBasePath;
                    {
                        this.projectBasePath = project.getBasePath();
                    }

                    public boolean process(VirtualFile file2) {
                        if (this.filesInProjectToBeIndexed != 0) {
                            sampleOfChangedFilePathsToBeIndexed.append(", ");
                        }
                        String filePath = file2.getPath();
                        String loggedPath = this.projectBasePath != null ? FileUtil.getRelativePath((String)this.projectBasePath, (String)filePath, (char)'/') : null;
                        loggedPath = loggedPath == null ? filePath : "%project_path%/" + loggedPath;
                        sampleOfChangedFilePathsToBeIndexed.append(loggedPath);
                        return ++this.filesInProjectToBeIndexed < ourMinFilesToStartDumMode;
                    }
                });
                return super.toString() + " [" + project + ", " + sampleOfChangedFilePathsToBeIndexed + "]";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/indexing/FileBasedIndexProjectHandler$4", "performInDumbMode"));
            }
        };
    }

    private static boolean mightHaveManyChangedFilesInProject(Project project, FileBasedIndexImpl index) {
        final long start2 = System.currentTimeMillis();
        return !index.processChangedFiles(project, (Processor<? super VirtualFile>)new Processor<VirtualFile>(){
            int filesInProjectToBeIndexed;
            int sizeOfFilesToBeIndexed;

            public boolean process(VirtualFile file2) {
                ++this.filesInProjectToBeIndexed;
                if (file2.isValid() && !file2.isDirectory()) {
                    this.sizeOfFilesToBeIndexed = (int)((long)this.sizeOfFilesToBeIndexed + file2.getLength());
                }
                return this.filesInProjectToBeIndexed < ourMinFilesToStartDumMode && this.sizeOfFilesToBeIndexed < ourMinFilesSizeToStartDumMode && System.currentTimeMillis() < start2 + 100L;
            }
        });
    }

    private static void reindexRefreshedFiles(ProgressIndicator indicator, Collection<VirtualFile> files2, Project project, FileBasedIndexImpl index) {
        CacheUpdateRunner.processFiles(indicator, files2, project, (Consumer<? super FileContent>)((Consumer)content2 -> index.processRefreshedFile(project, (FileContent)content2)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexProjectHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSet";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateIndexableFilesIn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

