/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.lang.refactoring.InlineHandlers;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.inline.GenericInlineHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineRefactoringActionHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineHandler");
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.title");

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements2, DataContext dataContext) {
        if (project == null) {
            InlineRefactoringActionHandler.$$$reportNull$$$0(0);
        }
        if (elements2 == null) {
            InlineRefactoringActionHandler.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(elements2.length == 1);
        if (dataContext == null) {
            dataContext = DataManager.getInstance().getDataContext();
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        for (InlineActionHandler handler2 : InlineActionHandler.EP_NAME.getExtensionList()) {
            if (!handler2.canInlineElement(elements2[0])) continue;
            handler2.inlineElement(project, editor, elements2[0]);
            return;
        }
        InlineRefactoringActionHandler.invokeInliner(editor, elements2[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            InlineRefactoringActionHandler.$$$reportNull$$$0(2);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element == null) {
            element = BaseRefactoringAction.getElementAtCaret(editor, file2);
        }
        if (element != null) {
            for (InlineActionHandler handler2 : InlineActionHandler.EP_NAME.getExtensionList()) {
                if (!handler2.canInlineElementInEditor(element, editor)) continue;
                handler2.inlineElement(project, editor, element);
                return;
            }
            if (InlineRefactoringActionHandler.invokeInliner(editor, element)) {
                return;
            }
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.local.name"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
        }
    }

    public static boolean invokeInliner(@Nullable Editor editor, PsiElement element) {
        List handlers = InlineHandlers.getInlineHandlers((Language)element.getLanguage());
        for (InlineHandler handler2 : handlers) {
            if (!GenericInlineHandler.invoke(element, editor, handler2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/inline/InlineRefactoringActionHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

