/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.table;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.SeverityEditorDialog;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JTable;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class SeverityRenderer
extends ComboBoxTableRenderer<HighlightSeverity> {
    static final HighlightSeverity EDIT_SEVERITIES = new HighlightSeverity(InspectionsBundle.message((String)"inspection.edit.severities.text", (Object[])new Object[0]), -1);
    @NotNull
    private final Runnable myOnClose;
    private final ScopesAndSeveritiesTable myTable;
    @NotNull
    private final Icon myDisabledIcon;
    @NotNull
    private final Project myProject;

    public SeverityRenderer(@NotNull InspectionProfileImpl inspectionProfile, @NotNull Project project, @NotNull Runnable onClose2, @NotNull ScopesAndSeveritiesTable table) {
        if (inspectionProfile == null) {
            SeverityRenderer.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SeverityRenderer.$$$reportNull$$$0(1);
        }
        if (onClose2 == null) {
            SeverityRenderer.$$$reportNull$$$0(2);
        }
        if (table == null) {
            SeverityRenderer.$$$reportNull$$$0(3);
        }
        super((Object[])SeverityRenderer.getSeverities(inspectionProfile));
        this.myOnClose = onClose2;
        this.myTable = table;
        this.myDisabledIcon = HighlightDisplayLevel.createIconByMask((Color)UIUtil.getLabelDisabledForeground());
        this.myProject = project;
    }

    @NotNull
    public static HighlightSeverity[] getSeverities(InspectionProfileImpl inspectionProfile) {
        Stream severities = LevelChooserAction.getSeverities(inspectionProfile.getProfileManager().getSeverityRegistrar()).stream();
        HighlightSeverity[] highlightSeverityArray = (HighlightSeverity[])StreamEx.of(severities).append((Object)EDIT_SEVERITIES).toArray(HighlightSeverity.class);
        if (highlightSeverityArray == null) {
            SeverityRenderer.$$$reportNull$$$0(4);
        }
        return highlightSeverityArray;
    }

    public static Icon getIcon(@NotNull HighlightDisplayLevel level) {
        Icon icon;
        if (level == null) {
            SeverityRenderer.$$$reportNull$$$0(5);
        }
        return (icon = level.getIcon()) instanceof HighlightDisplayLevel.ColoredIcon ? new ColorIcon(icon.getIconWidth(), ((HighlightDisplayLevel.ColoredIcon)icon).getColor()) : icon;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        component.setEnabled(((ScopesAndSeveritiesTable)((Object)table)).isRowEnabled(row));
        return component;
    }

    protected void customizeComponent(HighlightSeverity value, JTable table, boolean isSelected) {
        super.customizeComponent((Object)value, table, isSelected);
        this.setDisabledIcon(this.myDisabledIcon);
    }

    protected String getTextFor(@NotNull HighlightSeverity value) {
        if (value == null) {
            SeverityRenderer.$$$reportNull$$$0(6);
        }
        return SingleInspectionProfilePanel.renderSeverity(value);
    }

    protected Icon getIconFor(@NotNull HighlightSeverity value) {
        if (value == null) {
            SeverityRenderer.$$$reportNull$$$0(7);
        }
        return value == EDIT_SEVERITIES ? EmptyIcon.create((int)HighlightDisplayLevel.getEmptyIconDim()) : SeverityRenderer.getIcon(HighlightDisplayLevel.find((HighlightSeverity)value));
    }

    public boolean isCellEditable(EventObject event) {
        return !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() >= 1;
    }

    protected ListSeparator getSeparatorAbove(HighlightSeverity value) {
        return value == EDIT_SEVERITIES ? new ListSeparator() : null;
    }

    public void onClosed(@NotNull LightweightWindowEvent event) {
        if (event == null) {
            SeverityRenderer.$$$reportNull$$$0(8);
        }
        super.onClosed(event);
        this.myOnClose.run();
        if (this.getCellEditorValue() == EDIT_SEVERITIES) {
            ApplicationManager.getApplication().invokeLater(() -> SeverityEditorDialog.show(this.myProject, null, SeverityRegistrar.getSeverityRegistrar(this.myProject), true, (Consumer<? super HighlightSeverity>)((Consumer)severity -> this.myTable.setSelectedSeverity((HighlightSeverity)severity))));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionProfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onClose";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/table/SeverityRenderer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/table/SeverityRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTextFor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIconFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onClosed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

