/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.service.project.ProjectRenameAware;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.ui.ExternalToolWindowManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import org.jetbrains.annotations.NotNull;

final class ExternalSystemStartupActivity
implements StartupActivity,
DumbAware {
    ExternalSystemStartupActivity() {
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            ExternalSystemStartupActivity.$$$reportNull$$$0(0);
        }
        ExternalProjectsManagerImpl.getInstance(project).init();
        Runnable task2 = () -> {
            for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
                if (!(manager instanceof StartupActivity)) continue;
                ((StartupActivity)manager).runActivity(project);
            }
            if (project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) != Boolean.TRUE) {
                for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
                    boolean isNewProject;
                    boolean bl = isNewProject = project.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == Boolean.TRUE;
                    if (!isNewProject) continue;
                    ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project, manager.getSystemId()).createDirectoriesForEmptyContentRoots());
                }
            }
            ExternalToolWindowManager.handle(project);
            ProjectRenameAware.beAware(project);
        };
        ApplicationManager.getApplication().invokeLater(task2, project.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ExternalSystemStartupActivity", "runActivity"));
    }
}

