/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalEntityData;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OpenExternalConfigAction
extends ExternalSystemNodeAction<ExternalConfigPathAware> {
    public OpenExternalConfigAction() {
        super(ExternalConfigPathAware.class);
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.open.config.text", (Object[])new Object[]{"External"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.open.config.description", (Object[])new Object[]{"external"}));
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenExternalConfigAction.$$$reportNull$$$0(0);
        }
        if (!super.isEnabled(e)) {
            return false;
        }
        ExternalEntityData externalData = this.getExternalData(e, ExternalEntityData.class);
        if (!(externalData instanceof ExternalConfigPathAware)) {
            return false;
        }
        VirtualFile config2 = this.getExternalConfig((ExternalConfigPathAware)externalData, externalData.getOwner());
        if (config2 == null) {
            return false;
        }
        ProjectSystemId externalSystemId = this.getSystemId(e);
        e.getPresentation().setText(ExternalSystemBundle.message((String)"action.open.config.text", (Object[])new Object[]{externalSystemId.getReadableName()}));
        e.getPresentation().setDescription(ExternalSystemBundle.message((String)"action.open.config.description", (Object[])new Object[]{externalSystemId.getReadableName()}));
        ExternalSystemUiAware uiAware = this.getExternalSystemUiAware(e);
        if (uiAware != null) {
            e.getPresentation().setIcon(uiAware.getProjectIcon());
        }
        return true;
    }

    @Override
    protected void perform(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull ExternalConfigPathAware configPathAware, @NotNull AnActionEvent e) {
        VirtualFile configFile;
        if (project == null) {
            OpenExternalConfigAction.$$$reportNull$$$0(1);
        }
        if (systemId == null) {
            OpenExternalConfigAction.$$$reportNull$$$0(2);
        }
        if (configPathAware == null) {
            OpenExternalConfigAction.$$$reportNull$$$0(3);
        }
        if (e == null) {
            OpenExternalConfigAction.$$$reportNull$$$0(4);
        }
        if ((configFile = this.getExternalConfig(configPathAware, systemId)) != null) {
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, configFile);
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor2, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPathAware";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/OpenExternalConfigAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

