/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ServiceModelFilter {
    private final List<ServiceViewFilter> myFilters = new CopyOnWriteArrayList<ServiceViewFilter>();

    ServiceModelFilter() {
    }

    List<ServiceViewFilter> getFilters() {
        return this.myFilters;
    }

    void removeFilter(@NotNull ServiceViewFilter filter) {
        if (filter == null) {
            ServiceModelFilter.$$$reportNull$$$0(0);
        }
        ServiceViewFilter parent = filter.getParent();
        this.myFilters.remove(filter);
        for (ServiceViewFilter viewFilter : this.myFilters) {
            if (viewFilter.getParent() != filter) continue;
            viewFilter.setParent(parent);
        }
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> filter(@NotNull List<? extends ServiceModel.ServiceViewItem> items, @Nullable ServiceViewFilter targetFilter) {
        if (items == null) {
            ServiceModelFilter.$$$reportNull$$$0(1);
        }
        if (items.isEmpty()) {
            List<? extends ServiceModel.ServiceViewItem> list2 = items;
            if (list2 == null) {
                ServiceModelFilter.$$$reportNull$$$0(2);
            }
            return list2;
        }
        List<ServiceViewFilter> filters = targetFilter == null ? this.myFilters : this.excludeTargetAndParents(targetFilter);
        List list3 = ContainerUtil.filter(items, item -> filters.stream().noneMatch(filter -> filter.value(item)));
        if (list3 == null) {
            ServiceModelFilter.$$$reportNull$$$0(3);
        }
        return list3;
    }

    private List<ServiceViewFilter> excludeTargetAndParents(@NotNull ServiceViewFilter targetFilter) {
        if (targetFilter == null) {
            ServiceModelFilter.$$$reportNull$$$0(4);
        }
        ArrayList<ServiceViewFilter> filters = new ArrayList<ServiceViewFilter>(this.myFilters);
        do {
            filters.remove(targetFilter);
        } while ((targetFilter = targetFilter.getParent()) != null);
        return filters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceModelFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceModelFilter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeFilter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "excludeTargetAndParents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class ServiceViewFilter
    implements Condition<ServiceModel.ServiceViewItem> {
        private ServiceViewFilter myParent;

        protected ServiceViewFilter(@Nullable ServiceViewFilter parent) {
            this.myParent = parent;
        }

        @Nullable
        ServiceViewFilter getParent() {
            return this.myParent;
        }

        private void setParent(@Nullable ServiceViewFilter parent) {
            this.myParent = parent;
        }
    }
}

