/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixTemplateLogger {
    private static final String USAGE_GROUP = "completion.postfix";
    private static final String CUSTOM = "custom";
    private static final String NO_PROVIDER = "no.provider";
    private static final String TEMPLATE_FIELD = "template";

    static void log(@NotNull PostfixTemplate template, @NotNull PsiElement context) {
        if (template == null) {
            PostfixTemplateLogger.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PostfixTemplateLogger.$$$reportNull$$$0(1);
        }
        FeatureUsageData data = new FeatureUsageData().addLanguage(context.getLanguage());
        if (template.isBuiltin()) {
            data.addData(TEMPLATE_FIELD, template.getId());
            PostfixTemplateProvider provider = template.getProvider();
            String providerId = provider != null ? provider.getId() : NO_PROVIDER;
            FUCounterUsageLogger.getInstance().logEvent(context.getProject(), USAGE_GROUP, providerId, data);
        } else {
            FUCounterUsageLogger.getInstance().logEvent(context.getProject(), USAGE_GROUP, CUSTOM, data);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = TEMPLATE_FIELD;
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateLogger";
        objectArray[2] = "log";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PostfixTemplateValidator
    extends CustomWhiteListRule {
        @Override
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "completion_template".equals(ruleId) || "completion_provider_template".equals(ruleId);
        }

        @Override
        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            Pair<PostfixTemplate, PostfixTemplateProvider> template;
            String templateId;
            if (data == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(1);
            }
            if (StringUtil.equals((CharSequence)data, (CharSequence)PostfixTemplateLogger.CUSTOM) || StringUtil.equals((CharSequence)data, (CharSequence)PostfixTemplateLogger.NO_PROVIDER)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            Language lang = this.getLanguage(context);
            if (lang == null) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            String providerId = context.eventId;
            String string = templateId = context.eventData.containsKey(PostfixTemplateLogger.TEMPLATE_FIELD) ? context.eventData.get(PostfixTemplateLogger.TEMPLATE_FIELD).toString() : null;
            if ((StringUtil.equals((CharSequence)data, (CharSequence)providerId) || StringUtil.equals((CharSequence)data, (CharSequence)templateId)) && StringUtil.isNotEmpty((String)templateId) && (template = PostfixTemplateValidator.findPostfixTemplate(lang, providerId, templateId)).getFirst() != null && template.getSecond() != null) {
                PluginInfo templateInfo = PluginInfoDetectorKt.getPluginInfo(((PostfixTemplate)template.getFirst()).getClass());
                PluginInfo providerInfo = PluginInfoDetectorKt.getPluginInfo(((PostfixTemplateProvider)template.getSecond()).getClass());
                if (StringUtil.equals((CharSequence)data, (CharSequence)context.eventId)) {
                    context.setPluginInfo(templateInfo);
                }
                ValidationResultType validationResultType = templateInfo.isDevelopedByJetBrains() && providerInfo.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(4);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(5);
            }
            return validationResultType;
        }

        @NotNull
        private static Pair<PostfixTemplate, PostfixTemplateProvider> findPostfixTemplate(@NotNull Language lang, @NotNull String providerId, @NotNull String templateId) {
            if (lang == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(6);
            }
            if (providerId == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(7);
            }
            if (templateId == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(8);
            }
            if (!StringUtil.equals((CharSequence)providerId, (CharSequence)PostfixTemplateLogger.NO_PROVIDER)) {
                PostfixTemplateProvider provider = PostfixTemplateValidator.findProviderById(providerId, lang);
                PostfixTemplate template = provider != null ? PostfixTemplateValidator.findTemplateById(provider, templateId) : null;
                Pair pair = provider != null && template != null ? Pair.create((Object)template, (Object)provider) : Pair.empty();
                if (pair == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(9);
                }
                return pair;
            }
            for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(lang)) {
                PostfixTemplate template = PostfixTemplateValidator.findTemplateById(provider, templateId);
                if (template == null) continue;
                Pair pair = Pair.create((Object)template, (Object)provider);
                if (pair == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(10);
                }
                return pair;
            }
            Pair pair = Pair.empty();
            if (pair == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(11);
            }
            return pair;
        }

        @Nullable
        private static PostfixTemplateProvider findProviderById(@NotNull String id, @NotNull Language lang) {
            if (id == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(12);
            }
            if (lang == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(13);
            }
            for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(lang)) {
                if (!StringUtil.equals((CharSequence)provider.getId(), (CharSequence)id)) continue;
                return provider;
            }
            return null;
        }

        @Nullable
        private static PostfixTemplate findTemplateById(@NotNull PostfixTemplateProvider provider, @NotNull String id) {
            if (provider == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(14);
            }
            if (id == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(15);
            }
            for (PostfixTemplate template : provider.getTemplates()) {
                if (!StringUtil.equals((CharSequence)template.getId(), (CharSequence)id)) continue;
                return template;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateLogger$PostfixTemplateValidator";
                    break;
                }
                case 6: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lang";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "providerId";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateId";
                    break;
                }
                case 12: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateLogger$PostfixTemplateValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findPostfixTemplate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findPostfixTemplate";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "findProviderById";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "findTemplateById";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

