/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubPermissions;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsSecurityService;
import org.jetbrains.plugins.github.util.GithubSharedProjectSettings;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsSecurityServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsSecurityService;", "sharedProjectSettings", "Lorg/jetbrains/plugins/github/util/GithubSharedProjectSettings;", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "repo", "Lorg/jetbrains/plugins/github/api/data/GithubRepoDetailed;", "(Lorg/jetbrains/plugins/github/util/GithubSharedProjectSettings;Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;Lorg/jetbrains/plugins/github/api/data/GithubRepoDetailed;)V", "isCurrentUser", "", "user", "Lorg/jetbrains/plugins/github/api/data/GithubUser;", "isCurrentUserWithPushAccess", "isMergeAllowed", "isMergeForbiddenForProject", "isRebaseMergeAllowed", "isSquashMergeAllowed", "intellij.vcs.github"})
public final class GithubPullRequestsSecurityServiceImpl
implements GithubPullRequestsSecurityService {
    private final GithubSharedProjectSettings sharedProjectSettings;
    private final GithubAuthenticatedUser currentUser;
    private final GithubRepoDetailed repo;

    @Override
    public boolean isCurrentUser(@NotNull GithubUser user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return Intrinsics.areEqual((Object)user, (Object)this.currentUser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCurrentUserWithPushAccess() {
        GithubPermissions githubPermissions = this.repo.getPermissions();
        Intrinsics.checkExpressionValueIsNotNull((Object)githubPermissions, (String)"repo.permissions");
        if (githubPermissions.isPush()) return true;
        GithubPermissions githubPermissions2 = this.repo.getPermissions();
        Intrinsics.checkExpressionValueIsNotNull((Object)githubPermissions2, (String)"repo.permissions");
        if (!githubPermissions2.isAdmin()) return false;
        return true;
    }

    @Override
    public boolean isMergeAllowed() {
        return this.repo.getAllowMergeCommit();
    }

    @Override
    public boolean isRebaseMergeAllowed() {
        return this.repo.getAllowRebaseMerge();
    }

    @Override
    public boolean isSquashMergeAllowed() {
        return this.repo.getAllowSquashMerge();
    }

    @Override
    public boolean isMergeForbiddenForProject() {
        return this.sharedProjectSettings.getPullRequestMergeForbidden();
    }

    public GithubPullRequestsSecurityServiceImpl(@NotNull GithubSharedProjectSettings sharedProjectSettings, @NotNull GithubAuthenticatedUser currentUser, @NotNull GithubRepoDetailed repo) {
        Intrinsics.checkParameterIsNotNull((Object)sharedProjectSettings, (String)"sharedProjectSettings");
        Intrinsics.checkParameterIsNotNull((Object)currentUser, (String)"currentUser");
        Intrinsics.checkParameterIsNotNull((Object)repo, (String)"repo");
        this.sharedProjectSettings = sharedProjectSettings;
        this.currentUser = currentUser;
        this.repo = repo;
    }
}

