/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitNewBranchOptions;
import git4idea.commands.Git;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GithubPullRequest;
import org.jetbrains.plugins.github.api.data.GithubPullRequestDetailedWithHtml;
import org.jetbrains.plugins.github.pullrequest.action.GithubPullRequestCreateBranchAction;
import org.jetbrains.plugins.github.pullrequest.action.GithubPullRequestKeys;
import org.jetbrains.plugins.github.pullrequest.action.GithubPullRequestsDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestDataProvider;
import org.jetbrains.plugins.github.util.GithubAsyncUtil;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/action/GithubPullRequestCreateBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.vcs.github"})
public final class GithubPullRequestCreateBranchAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        GithubPullRequestsDataContext githubPullRequestsDataContext = (GithubPullRequestsDataContext)e.getData(GithubPullRequestKeys.getDATA_CONTEXT());
        GithubPullRequestDataProvider selection = githubPullRequestsDataContext != null ? githubPullRequestsDataContext.getSelectedPullRequestDataProvider() : null;
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(project != null && !project.isDefault() && selection != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"e.getRequiredData(CommonDataKeys.PROJECT)");
        Project project = (Project)object;
        Object object2 = e.getRequiredData(GithubPullRequestKeys.getDATA_CONTEXT());
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"e.getRequiredData(Github\u2026RequestKeys.DATA_CONTEXT)");
        GithubPullRequestsDataContext context = (GithubPullRequestsDataContext)object2;
        GitRepository repository = context.getGitRepository();
        List repositoryList = CollectionsKt.listOf((Object)repository);
        GithubPullRequestDataProvider githubPullRequestDataProvider = context.getSelectedPullRequestDataProvider();
        if (githubPullRequestDataProvider == null) {
            return;
        }
        GithubPullRequestDataProvider dataProvider = githubPullRequestDataProvider;
        GitNewBranchOptions gitNewBranchOptions = GitBranchUtil.getNewBranchNameFromUser((Project)project, (Collection)CollectionsKt.listOf((Object)repository), (String)("Create New Branch From Pull Request #" + dataProvider.getNumber()), (String)("pull/" + dataProvider.getNumber()));
        if (gitNewBranchOptions == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gitNewBranchOptions, (String)"GitBranchUtil.getNewBran\u2026vider.number}\") ?: return");
        GitNewBranchOptions options = gitNewBranchOptions;
        if (!options.shouldCheckout()) {
            new Task.Backgroundable(dataProvider, project, options, repository, project, "Creating Branch From Pull Request", true){
                private final Git git;
                private final VcsNotifier vcsNotifier;
                final /* synthetic */ GithubPullRequestDataProvider $dataProvider;
                final /* synthetic */ Project $project;
                final /* synthetic */ GitNewBranchOptions $options;
                final /* synthetic */ GitRepository $repository;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                    T t = GithubAsyncUtil.awaitFuture(indicator, this.$dataProvider.getDetailsRequest());
                    Intrinsics.checkExpressionValueIsNotNull(t, (String)"GithubAsyncUtil.awaitFut\u2026aProvider.detailsRequest)");
                    GithubPullRequest.Tag tag = ((GithubPullRequestDetailedWithHtml)t).getHead();
                    Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"GithubAsyncUtil.awaitFut\u2026ider.detailsRequest).head");
                    String string = tag.getSha();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GithubAsyncUtil.awaitFut\u2026.detailsRequest).head.sha");
                    String sha = string;
                    GithubAsyncUtil.awaitFuture(indicator, this.$dataProvider.getBranchFetchRequest());
                    indicator.setText("Creating branch");
                    new GitBranchWorker(this.$project, this.git, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, this.git, indicator)).createBranch(this.$options.getName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)this.$repository, (Object)sha)));
                }

                public void onSuccess() {
                    this.vcsNotifier.notifySuccess("Created Branch " + this.$options.getName());
                }

                public void onThrowable(@NotNull Throwable error) {
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    String string = error.getMessage();
                    String string2 = "Failed To Create Branch";
                    VcsNotifier vcsNotifier = this.vcsNotifier;
                    boolean bl = false;
                    String string3 = string;
                    if (string3 == null) {
                        string3 = "";
                    }
                    String string4 = string3;
                    vcsNotifier.notifyError(string2, string4);
                }
                {
                    void $this$service$iv;
                    this.$dataProvider = $captured_local_variable$0;
                    this.$project = $captured_local_variable$1;
                    this.$options = $captured_local_variable$2;
                    this.$repository = $captured_local_variable$3;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                    Git git = Git.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)git, (String)"Git.getInstance()");
                    this.git = git;
                    Project project = $captured_local_variable$1;
                    actionPerformed.1 var10_9 = this;
                    boolean $i$f$service = false;
                    Object object = ServiceManager.getService((Project)$this$service$iv, VcsNotifier.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
                    Object object2 = object;
                    var10_9.vcsNotifier = (VcsNotifier)object2;
                }
            }.queue();
        } else {
            new Task.Backgroundable(dataProvider, project, options, repositoryList, project, "Checking Out Branch From Pull Request", true){
                private final Git git;
                private final VcsNotifier vcsNotifier;
                final /* synthetic */ GithubPullRequestDataProvider $dataProvider;
                final /* synthetic */ Project $project;
                final /* synthetic */ GitNewBranchOptions $options;
                final /* synthetic */ List $repositoryList;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                    T t = GithubAsyncUtil.awaitFuture(indicator, this.$dataProvider.getDetailsRequest());
                    Intrinsics.checkExpressionValueIsNotNull(t, (String)"GithubAsyncUtil.awaitFut\u2026aProvider.detailsRequest)");
                    GithubPullRequest.Tag tag = ((GithubPullRequestDetailedWithHtml)t).getHead();
                    Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"GithubAsyncUtil.awaitFut\u2026ider.detailsRequest).head");
                    String string = tag.getSha();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GithubAsyncUtil.awaitFut\u2026.detailsRequest).head.sha");
                    String sha = string;
                    GithubAsyncUtil.awaitFuture(indicator, this.$dataProvider.getBranchFetchRequest());
                    indicator.setText("Checking out branch");
                    new GitBranchWorker(this.$project, this.git, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, this.git, indicator)).checkoutNewBranchStartingFrom(this.$options.getName(), sha, this.$repositoryList);
                }

                public void onSuccess() {
                    this.vcsNotifier.notifySuccess("Checked Out Branch " + this.$options.getName());
                }

                public void onThrowable(@NotNull Throwable error) {
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    String string = error.getMessage();
                    String string2 = "Failed to Checkout Branch";
                    VcsNotifier vcsNotifier = this.vcsNotifier;
                    boolean bl = false;
                    String string3 = string;
                    if (string3 == null) {
                        string3 = "";
                    }
                    String string4 = string3;
                    vcsNotifier.notifyError(string2, string4);
                }
                {
                    void $this$service$iv;
                    this.$dataProvider = $captured_local_variable$0;
                    this.$project = $captured_local_variable$1;
                    this.$options = $captured_local_variable$2;
                    this.$repositoryList = $captured_local_variable$3;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                    Git git = Git.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)git, (String)"Git.getInstance()");
                    this.git = git;
                    Project project = $captured_local_variable$1;
                    actionPerformed.2 var10_9 = this;
                    boolean $i$f$service = false;
                    Object object = ServiceManager.getService((Project)$this$service$iv, VcsNotifier.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
                    Object object2 = object;
                    var10_9.vcsNotifier = (VcsNotifier)object2;
                }
            }.queue();
        }
    }

    public GithubPullRequestCreateBranchAction() {
        super("Create New Local Branch...", "Checkout synthetic pull request branch", null);
    }
}

