/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsLogFilterCollection {
    public static final FilterKey<VcsLogBranchFilter> BRANCH_FILTER = FilterKey.create("branch");
    public static final FilterKey<VcsLogRangeFilter> RANGE_FILTER = FilterKey.create("range");
    public static final FilterKey<VcsLogRevisionFilter> REVISION_FILTER = FilterKey.create("revision");
    public static final FilterKey<VcsLogUserFilter> USER_FILTER = FilterKey.create("user");
    public static final FilterKey<VcsLogHashFilter> HASH_FILTER = FilterKey.create("hash");
    public static final FilterKey<VcsLogDateFilter> DATE_FILTER = FilterKey.create("date");
    public static final FilterKey<VcsLogTextFilter> TEXT_FILTER = FilterKey.create("text");
    public static final FilterKey<VcsLogStructureFilter> STRUCTURE_FILTER = FilterKey.create("structure");
    public static final FilterKey<VcsLogRootFilter> ROOT_FILTER = FilterKey.create("roots");
    public static final Collection<FilterKey<? extends VcsLogFilter>> STANDARD_KEYS = ContainerUtil.newArrayList((Object[])new FilterKey[]{BRANCH_FILTER, REVISION_FILTER, RANGE_FILTER, USER_FILTER, HASH_FILTER, DATE_FILTER, TEXT_FILTER, STRUCTURE_FILTER, ROOT_FILTER});

    @Nullable
    public <T extends VcsLogFilter> T get(@NotNull FilterKey<T> var1);

    default public boolean isEmpty() {
        return this.getFilters().isEmpty();
    }

    @NotNull
    public Collection<VcsLogFilter> getFilters();

    @NotNull
    default public List<VcsLogDetailsFilter> getDetailsFilters() {
        List list = ContainerUtil.findAll(this.getFilters(), VcsLogDetailsFilter.class);
        if (list == null) {
            VcsLogFilterCollection.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/VcsLogFilterCollection", "getDetailsFilters"));
    }

    public static class FilterKey<T extends VcsLogFilter> {
        @NotNull
        private final String myName;

        public FilterKey(@NotNull String name) {
            if (name == null) {
                FilterKey.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                FilterKey.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterKey key = (FilterKey)o;
            return Objects.equals(this.myName, key.myName);
        }

        public int hashCode() {
            return Objects.hash(this.myName);
        }

        public static <T extends VcsLogFilter> FilterKey<T> create(@NotNull String name) {
            if (name == null) {
                FilterKey.$$$reportNull$$$0(2);
            }
            return new FilterKey<T>(name);
        }

        public String toString() {
            return this.myName + " filter";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/VcsLogFilterCollection$FilterKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/VcsLogFilterCollection$FilterKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

