/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.FileASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiFile
extends PsiFileSystemItem {
    public static final PsiFile[] EMPTY_ARRAY = new PsiFile[0];

    @Override
    public VirtualFile getVirtualFile();

    public PsiDirectory getContainingDirectory();

    @Override
    public PsiDirectory getParent();

    public long getModificationStamp();

    @NotNull
    public PsiFile getOriginalFile();

    @NotNull
    public FileType getFileType();

    @Deprecated
    @NotNull
    public PsiFile[] getPsiRoots();

    @NotNull
    public FileViewProvider getViewProvider();

    @Override
    public FileASTNode getNode();

    public void subtreeChanged();

    default public void clearCaches() {
    }

    @Nullable
    default public IFileElementType getFileElementType() {
        return (IFileElementType)ObjectUtils.tryCast((Object)PsiUtilCore.getElementType(this.getNode()), IFileElementType.class);
    }
}

