/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentUtil {
    public static boolean isMinimized(@Nullable Window window) {
        if (!(window instanceof Frame)) {
            return false;
        }
        Frame frame = (Frame)window;
        return frame.getExtendedState() == 1;
    }

    @NotNull
    public static Window getActiveWindow() {
        for (Window each : Window.getWindows()) {
            if (!each.isVisible() || !each.isActive()) continue;
            Window window = each;
            if (window == null) {
                ComponentUtil.$$$reportNull$$$0(0);
            }
            return window;
        }
        Frame frame = JOptionPane.getRootFrame();
        if (frame == null) {
            ComponentUtil.$$$reportNull$$$0(1);
        }
        return frame;
    }

    @NotNull
    public static Component findUltimateParent(@NotNull Component c) {
        if (c == null) {
            ComponentUtil.$$$reportNull$$$0(2);
        }
        Component eachParent = c;
        while (true) {
            if (eachParent.getParent() == null) {
                Component component = eachParent;
                if (component == null) {
                    ComponentUtil.$$$reportNull$$$0(3);
                }
                return component;
            }
            eachParent = eachParent.getParent();
        }
    }

    @Nullable
    public static Window getWindow(@Nullable Component component) {
        if (component == null) {
            return null;
        }
        return component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
    }

    @Nullable
    public static Component findParentByCondition(@Nullable Component c, @NotNull Predicate<? super Component> condition) {
        if (condition == null) {
            ComponentUtil.$$$reportNull$$$0(4);
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!condition.test(eachParent)) continue;
            return eachParent;
        }
        return null;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getParentOfType(@NotNull Class<? extends T> type, Component component) {
        if (type == null) {
            ComponentUtil.$$$reportNull$$$0(5);
        }
        while (component != null) {
            if (type.isInstance(component)) {
                return (T)component;
            }
            component = component.getParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ComponentUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ComponentUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUltimateParent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findUltimateParent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findParentByCondition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

