/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class TextWithMnemonic {
    @NotNull
    private final String myText;
    private final int myMnemonicIndex;

    private TextWithMnemonic(@NotNull String myText, int mnemonicIndex) {
        if (myText == null) {
            TextWithMnemonic.$$$reportNull$$$0(0);
        }
        this.myText = myText.isEmpty() ? "" : myText;
        this.myMnemonicIndex = mnemonicIndex;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            TextWithMnemonic.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getMnemonic() {
        return this.hasMnemonic() ? (int)Character.toUpperCase(this.myText.charAt(this.myMnemonicIndex)) : 0;
    }

    public int getMnemonicIndex() {
        return this.myMnemonicIndex;
    }

    public boolean hasMnemonic() {
        return this.myMnemonicIndex >= 0;
    }

    public TextWithMnemonic dropMnemonic() {
        return this.hasMnemonic() ? TextWithMnemonic.fromPlainText(this.myText) : this;
    }

    public TextWithMnemonic setMnemonicAt(int index) {
        if (index < 0 || index >= this.myText.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return index == this.myMnemonicIndex ? this : new TextWithMnemonic(this.myText, index);
    }

    public TextWithMnemonic append(@NotNull String textToAppend) {
        if (textToAppend == null) {
            TextWithMnemonic.$$$reportNull$$$0(2);
        }
        return new TextWithMnemonic(this.myText + textToAppend, this.myMnemonicIndex);
    }

    public TextWithMnemonic replaceFirst(@NotNull String target, @NotNull String replacement) {
        int index;
        if (target == null) {
            TextWithMnemonic.$$$reportNull$$$0(3);
        }
        if (replacement == null) {
            TextWithMnemonic.$$$reportNull$$$0(4);
        }
        if ((index = this.myText.indexOf(target)) == -1) {
            return this;
        }
        String resultText = this.myText.substring(0, index) + replacement + this.myText.substring(index + target.length());
        int resultIndex = this.myMnemonicIndex < index ? this.myMnemonicIndex : (this.myMnemonicIndex >= index + target.length() ? this.myMnemonicIndex - target.length() + replacement.length() : -1);
        return new TextWithMnemonic(resultText, resultIndex);
    }

    @NotNull
    @Contract(pure=true)
    public static TextWithMnemonic fromPlainText(@NotNull String text) {
        if (text == null) {
            TextWithMnemonic.$$$reportNull$$$0(5);
        }
        TextWithMnemonic textWithMnemonic = new TextWithMnemonic(text, -1);
        if (textWithMnemonic == null) {
            TextWithMnemonic.$$$reportNull$$$0(6);
        }
        return textWithMnemonic;
    }

    @NotNull
    @Contract(pure=true)
    public static TextWithMnemonic parse(@NotNull String text) {
        if (text == null) {
            TextWithMnemonic.$$$reportNull$$$0(7);
        }
        if (text.indexOf(27) >= 0) {
            text = text.replace('\u001b', '&');
        }
        if (text.contains("_") || text.contains("&")) {
            StringBuilder plainText = new StringBuilder();
            int mnemonicIndex = -1;
            int backShift = 0;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (mnemonicIndex == -1 && (ch == '_' || ch == '&')) {
                    if (++i >= text.length()) break;
                    ch = text.charAt(i);
                    if (ch != '_' && ch != '&') {
                        mnemonicIndex = i - 1 - backShift;
                    } else {
                        ++backShift;
                    }
                }
                plainText.append(ch);
            }
            TextWithMnemonic textWithMnemonic = new TextWithMnemonic(plainText.toString(), mnemonicIndex);
            if (textWithMnemonic == null) {
                TextWithMnemonic.$$$reportNull$$$0(8);
            }
            return textWithMnemonic;
        }
        TextWithMnemonic textWithMnemonic = TextWithMnemonic.fromPlainText(text);
        if (textWithMnemonic == null) {
            TextWithMnemonic.$$$reportNull$$$0(9);
        }
        return textWithMnemonic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextWithMnemonic mnemonic = (TextWithMnemonic)o;
        return this.myMnemonicIndex == mnemonic.myMnemonicIndex && this.myText.equals(mnemonic.myText);
    }

    public int hashCode() {
        return this.myText.hashCode() * 31 + this.myMnemonicIndex;
    }

    public String toString() {
        if (this.myMnemonicIndex > -1) {
            String prefix = StringUtil.escapeMnemonics((String)this.myText.substring(0, this.myMnemonicIndex));
            String suffix = this.myText.substring(this.myMnemonicIndex);
            return prefix + "_" + suffix;
        }
        return StringUtil.escapeMnemonics((String)this.myText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myText";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/TextWithMnemonic";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToAppend";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/TextWithMnemonic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromPlainText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceFirst";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromPlainText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

