/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyCondaRunKt;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CondaEnvSdkFlavor
extends CPythonSdkFlavor {
    public static final String[] CONDA_DEFAULT_ROOTS = new String[]{"anaconda", "anaconda2", "anaconda3", "miniconda", "miniconda2", "miniconda3", "Anaconda", "Anaconda2", "Anaconda3", "Miniconda", "Miniconda2", "Miniconda3"};
    public static final CondaEnvSdkFlavor INSTANCE = new CondaEnvSdkFlavor();

    private CondaEnvSdkFlavor() {
    }

    @Override
    public Collection<String> suggestHomePaths(@Nullable Module module2) {
        ArrayList<String> results = new ArrayList<String>();
        Sdk sdk = (Sdk)ReadAction.compute(() -> PythonSdkType.findPythonSdk(module2));
        try {
            List<String> environments = PyCondaRunKt.listCondaEnvironments(sdk);
            for (String environment : environments) {
                results.addAll((Collection)ReadAction.compute(() -> {
                    VirtualFile root = StandardFileSystems.local().findFileByPath(environment);
                    return ((StreamEx)StreamEx.of(VirtualEnvSdkFlavor.findInRootDirectory(root)).filter(s -> CondaEnvSdkFlavor.getCondaEnvRoot(s) != null)).toList();
                }));
            }
        }
        catch (ExecutionException e) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(0);
        }
        if (!super.isValidSdkPath(file)) {
            return false;
        }
        return PythonSdkType.isConda(file.getPath());
    }

    @Nullable
    public static File getCondaEnvRoot(@NotNull String binaryPath) {
        File binary;
        File parent;
        if (binaryPath == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(1);
        }
        if ((parent = (binary = new File(binaryPath)).getParentFile()) == null) {
            return null;
        }
        File parent2 = parent.getParentFile();
        if (parent2 == null) {
            return null;
        }
        File parent3 = parent2.getParentFile();
        if (parent3 != null && "envs".equals(parent3.getName())) {
            return parent2;
        }
        if ("envs".equals(parent2.getName())) {
            return parent;
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.Anaconda;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/sdk/flavors/CondaEnvSdkFlavor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidSdkPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCondaEnvRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

