/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.NullableConsumer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkDetailsStep
extends BaseListPopupStep<String> {
    @Nullable
    private final DialogWrapper myShowAll;
    @Nullable
    private final Project myProject;
    @Nullable
    private final Module myModule;
    private final Sdk[] myExistingSdks;
    private final NullableConsumer<? super Sdk> mySdkAddedCallback;
    private static final String ADD = PyBundle.message("sdk.details.step.add", new Object[0]);
    private static final String ALL = PyBundle.message("sdk.details.step.show.all", new Object[0]);

    public static void show(@Nullable Project project, @Nullable Module module2, @NotNull Sdk[] existingSdks, @NotNull DialogWrapper showAllDialog, @NotNull JComponent ownerComponent, @NotNull Point popupPoint, @NotNull NullableConsumer<? super Sdk> sdkAddedCallback) {
        if (existingSdks == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(0);
        }
        if (showAllDialog == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(1);
        }
        if (ownerComponent == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(2);
        }
        if (popupPoint == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(3);
        }
        if (sdkAddedCallback == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(4);
        }
        PythonSdkDetailsStep sdkHomesStep = new PythonSdkDetailsStep(project, module2, showAllDialog, existingSdks, sdkAddedCallback);
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)sdkHomesStep);
        popup.showInScreenCoordinates((Component)ownerComponent, popupPoint);
    }

    public PythonSdkDetailsStep(@Nullable Project project, @Nullable Module module2, @Nullable DialogWrapper showAllDialog, @NotNull Sdk[] existingSdks, @NotNull NullableConsumer<? super Sdk> sdkAddedCallback) {
        if (existingSdks == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(5);
        }
        if (sdkAddedCallback == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(6);
        }
        super(null, PythonSdkDetailsStep.getAvailableOptions(showAllDialog != null));
        this.myProject = project;
        this.myModule = module2;
        this.myShowAll = showAllDialog;
        this.myExistingSdks = existingSdks;
        this.mySdkAddedCallback = sdkAddedCallback;
    }

    private static List<String> getAvailableOptions(boolean showAll) {
        ArrayList<String> options = new ArrayList<String>();
        options.add(ADD);
        if (showAll) {
            options.add(ALL);
        }
        return options;
    }

    @Nullable
    public ListSeparator getSeparatorAbove(String value) {
        return ALL.equals(value) ? new ListSeparator() : null;
    }

    private void optionSelected(String selectedValue) {
        if (!ALL.equals(selectedValue) && this.myShowAll != null) {
            Disposer.dispose((Disposable)this.myShowAll.getDisposable());
        }
        if (ADD.equals(selectedValue)) {
            PyAddSdkDialog.show(this.myProject, this.myModule, Arrays.asList(this.myExistingSdks), sdk -> this.mySdkAddedCallback.consume(sdk));
        } else if (this.myShowAll != null) {
            this.myShowAll.show();
        }
    }

    public void canceled() {
        if (this.getFinalRunnable() == null && this.myShowAll != null) {
            Disposer.dispose((Disposable)this.myShowAll.getDisposable());
        }
    }

    public PopupStep onChosen(String selectedValue, boolean finalChoice) {
        return this.doFinalStep(() -> this.optionSelected(selectedValue));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showAllDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupPoint";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAddedCallback";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkDetailsStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

