/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject.steps;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.ide.util.projectWizard.ProjectSettingsStepBase;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HideableDecorator;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.newProject.PyFrameworkProjectGenerator;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.newProject.steps.PyAddExistingSdkPanel;
import com.jetbrains.python.newProject.steps.PyAddNewEnvironmentPanel;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.add.PyAddSdkGroupPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSpecificSettingsStep<T>
extends ProjectSettingsStepBase<T>
implements DumbAware {
    private boolean myInstallFramework;
    @Nullable
    private PyAddSdkGroupPanel myInterpreterPanel;

    public ProjectSpecificSettingsStep(@NotNull DirectoryProjectGenerator<T> projectGenerator, @NotNull AbstractNewProjectStep.AbstractCallback<T> callback) {
        if (projectGenerator == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(1);
        }
        super(projectGenerator, callback);
    }

    protected JPanel createAndFillContentPanel() {
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            ((PythonProjectGenerator)this.myProjectGenerator).setErrorCallback(arg_0 -> ((ProjectSpecificSettingsStep)this).setErrorText(arg_0));
        }
        return this.createContentPanelWithAdvancedSettingsPanel();
    }

    @Nullable
    protected JPanel createAdvancedSettings() {
        JComponent advancedSettings = null;
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            advancedSettings = ((PythonProjectGenerator)this.myProjectGenerator).getSettingsPanel(this.myProjectDirectory);
        } else if (this.myProjectGenerator instanceof WebProjectTemplate) {
            advancedSettings = this.getPeer().getComponent();
        }
        if (advancedSettings != null) {
            JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            HideableDecorator deco = new HideableDecorator(jPanel, "Mor&e Settings", false);
            if (this.myProjectGenerator instanceof PythonProjectGenerator) {
                ValidationResult result = ((PythonProjectGenerator)this.myProjectGenerator).warningValidation(this.getInterpreterPanelSdk());
                deco.setOn(!result.isOk());
            }
            deco.setContentComponent(advancedSettings);
            return jPanel;
        }
        return null;
    }

    @Nullable
    public Sdk getSdk() {
        if (!(this.myProjectGenerator instanceof PythonProjectGenerator)) {
            return null;
        }
        PyAddSdkGroupPanel interpreterPanel = this.myInterpreterPanel;
        if (interpreterPanel == null) {
            return null;
        }
        PyAddSdkPanel panel = interpreterPanel.getSelectedPanel();
        if (panel instanceof PyAddNewEnvironmentPanel) {
            PyAddNewEnvironmentPanel newEnvironmentPanel = (PyAddNewEnvironmentPanel)panel;
            return new PyLazySdk("Uninitialized environment", (NullableComputable<Sdk>)((NullableComputable)newEnvironmentPanel::getOrCreateSdk));
        }
        if (panel instanceof PyAddExistingSdkPanel) {
            return panel.getSdk();
        }
        return null;
    }

    @Nullable
    private Sdk getInterpreterPanelSdk() {
        PyAddSdkGroupPanel interpreterPanel = this.myInterpreterPanel;
        if (interpreterPanel == null) {
            return null;
        }
        return interpreterPanel.getSdk();
    }

    public boolean installFramework() {
        return this.myInstallFramework;
    }

    protected void registerValidators() {
        super.registerValidators();
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            this.addLocationChangeListener((Consumer<DocumentEvent>)((Consumer)event -> {
                String fileName = PathUtil.getFileName((String)this.getNewProjectPath());
                ((PythonProjectGenerator)this.myProjectGenerator).locationChanged(fileName);
            }));
        }
    }

    @Nullable
    final String getRemotePath() {
        PyAddSdkGroupPanel interpreterPanel = this.myInterpreterPanel;
        if (interpreterPanel == null) {
            return null;
        }
        PyAddExistingSdkPanel panel = (PyAddExistingSdkPanel)ObjectUtils.tryCast((Object)interpreterPanel.getSelectedPanel(), PyAddExistingSdkPanel.class);
        if (panel == null) {
            return null;
        }
        return panel.getRemotePath();
    }

    protected void initGeneratorListeners() {
        super.initGeneratorListeners();
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            ((PythonProjectGenerator)this.myProjectGenerator).addSettingsStateListener(this::checkValid);
            this.myErrorLabel.addMouseListener(((PythonProjectGenerator)this.myProjectGenerator).getErrorLabelMouseListener());
        }
    }

    public boolean checkValid() {
        List<ValidationInfo> validationInfos;
        this.myInstallFramework = false;
        if (!super.checkValid()) {
            return false;
        }
        PyAddSdkGroupPanel interpreterPanel = this.myInterpreterPanel;
        if (interpreterPanel != null && !(validationInfos = interpreterPanel.validateAll()).isEmpty()) {
            this.setErrorText(StringUtil.join(validationInfos, info -> info.message, (String)"\n"));
            return false;
        }
        PythonProjectGenerator generator = (PythonProjectGenerator)((Object)ObjectUtils.tryCast((Object)this.myProjectGenerator, PythonProjectGenerator.class));
        Sdk sdk = this.getInterpreterPanelSdk();
        if (generator == null || sdk == null) {
            this.myInstallFramework = true;
            return true;
        }
        try {
            generator.checkProjectCanBeCreatedOnSdk(sdk, new File(this.myLocationField.getText()));
        }
        catch (PythonProjectGenerator.PyNoProjectAllowedOnSdkException e) {
            this.setErrorText(e.getMessage());
            return false;
        }
        ArrayList<String> warnings = new ArrayList<String>();
        PyFrameworkProjectGenerator frameworkGenerator = (PyFrameworkProjectGenerator)ObjectUtils.tryCast((Object)this.myProjectGenerator, PyFrameworkProjectGenerator.class);
        if (frameworkGenerator != null) {
            String python3Error = ProjectSpecificSettingsStep.validateFrameworkSupportsPython3(frameworkGenerator, sdk);
            if (python3Error != null) {
                this.setErrorText(python3Error);
                return false;
            }
            if (!PythonSdkType.isRemote(sdk)) {
                Pair<Boolean, List<String>> validationInfo = ProjectSpecificSettingsStep.validateFramework(frameworkGenerator, sdk);
                this.myInstallFramework = (Boolean)validationInfo.first;
                warnings.addAll((Collection)validationInfo.second);
                ValidationResult warningResult = ((PythonProjectGenerator)this.myProjectGenerator).warningValidation(sdk);
                if (!warningResult.isOk()) {
                    warnings.add(warningResult.getErrorMessage());
                }
            }
        }
        if (!warnings.isEmpty()) {
            this.setWarningText(StringUtil.join(warnings, (String)"<br/>"));
        }
        return true;
    }

    private static String validateFrameworkSupportsPython3(@NotNull PyFrameworkProjectGenerator generator, @NotNull Sdk sdk) {
        if (generator == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(2);
        }
        if (sdk == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(3);
        }
        String frameworkName = generator.getFrameworkTitle();
        boolean isPy3k = PythonSdkType.getLanguageLevelForSdk(sdk).isPy3K();
        return isPy3k && !generator.supportsPython3() ? frameworkName + " is not supported for the selected interpreter" : null;
    }

    @NotNull
    private static Pair<Boolean, List<String>> validateFramework(@NotNull PyFrameworkProjectGenerator generator, @NotNull Sdk sdk) {
        if (generator == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(4);
        }
        if (sdk == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(5);
        }
        ArrayList<String> warnings = new ArrayList<String>();
        boolean installFramework = false;
        if (!generator.isFrameworkInstalled(sdk)) {
            String frameworkName = generator.getFrameworkTitle();
            if (PyPackageUtil.packageManagementEnabled(sdk)) {
                installFramework = true;
                List<PyPackage> packages = PyPackageUtil.refreshAndGetPackagesModally(sdk);
                if (!PyPackageUtil.hasManagement(packages)) {
                    warnings.add("Python packaging tools and " + frameworkName + " will be installed on the selected interpreter");
                } else {
                    warnings.add(frameworkName + " will be installed on the selected interpreter");
                }
            } else {
                warnings.add(frameworkName + " is not installed on the selected interpreter");
            }
        }
        Pair pair = Pair.create((Object)installFramework, warnings);
        if (pair == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(6);
        }
        return pair;
    }

    protected JPanel createBasePanel() {
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            BorderLayout layout = new BorderLayout();
            JPanel locationPanel = new JPanel(layout);
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 2));
            LabeledComponent location = this.createLocationComponent();
            locationPanel.add((Component)location, "Center");
            panel.add(locationPanel);
            panel.add(this.createInterpretersPanel(((PythonProjectGenerator)this.myProjectGenerator).getPreferredEnvironmentType()));
            JPanel basePanelExtension = ((PythonProjectGenerator)this.myProjectGenerator).extendBasePanel();
            if (basePanelExtension != null) {
                panel.add(basePanelExtension);
            }
            return panel;
        }
        return super.createBasePanel();
    }

    @NotNull
    private JPanel createInterpretersPanel(@Nullable String preferredEnvironment) {
        JPanel container = new JPanel(new BorderLayout());
        JPanel decoratorPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        List<Sdk> existingSdks = ProjectSpecificSettingsStep.getValidPythonSdks();
        Sdk preferredSdk = this.getPreferredSdk(existingSdks);
        String newProjectPath = this.getNewProjectPath();
        PyAddNewEnvironmentPanel newEnvironmentPanel = new PyAddNewEnvironmentPanel(existingSdks, newProjectPath, preferredEnvironment);
        PyAddExistingSdkPanel existingSdkPanel = new PyAddExistingSdkPanel(null, null, existingSdks, newProjectPath, preferredSdk);
        PyAddSdkPanel defaultPanel = PySdkSettings.getInstance().getUseNewEnvironmentForNewProject() ? newEnvironmentPanel : existingSdkPanel;
        HideableDecorator decorator = new HideableDecorator(decoratorPanel, ProjectSpecificSettingsStep.getProjectInterpreterTitle(defaultPanel), false);
        decorator.setContentComponent((JComponent)container);
        List<PyAddSdkPanel> panels = Arrays.asList(newEnvironmentPanel, existingSdkPanel);
        this.myInterpreterPanel = new PyAddSdkGroupPanel("New project interpreter", this.getIcon(), panels, defaultPanel);
        this.myInterpreterPanel.addChangeListener(() -> {
            decorator.setTitle(ProjectSpecificSettingsStep.getProjectInterpreterTitle(this.myInterpreterPanel.getSelectedPanel()));
            boolean useNewEnvironment = this.myInterpreterPanel.getSelectedPanel() instanceof PyAddNewEnvironmentPanel;
            PySdkSettings.getInstance().setUseNewEnvironmentForNewProject(useNewEnvironment);
            this.checkValid();
        });
        this.addLocationChangeListener((Consumer<DocumentEvent>)((Consumer)event -> this.myInterpreterPanel.setNewProjectPath(this.getNewProjectPath())));
        container.add((Component)this.myInterpreterPanel, "North");
        this.checkValid();
        JPanel jPanel = decoratorPanel;
        if (jPanel == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    private String getNewProjectPath() {
        TextFieldWithBrowseButton field = this.myLocationField;
        if (field == null) {
            if ("" == null) {
                ProjectSpecificSettingsStep.$$$reportNull$$$0(8);
            }
            return "";
        }
        String string = field.getText().trim();
        if (string == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(9);
        }
        return string;
    }

    private void addLocationChangeListener(final @NotNull Consumer<DocumentEvent> listener2) {
        TextFieldWithBrowseButton field;
        if (listener2 == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(10);
        }
        if ((field = this.myLocationField) == null) {
            return;
        }
        field.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                listener2.consume((Object)e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/newProject/steps/ProjectSpecificSettingsStep$1", "textChanged"));
            }
        });
    }

    @NotNull
    private static String getProjectInterpreterTitle(@NotNull PyAddSdkPanel panel) {
        Sdk sdk;
        if (panel == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(11);
        }
        String name = panel instanceof PyAddNewEnvironmentPanel ? "New " + ((PyAddNewEnvironmentPanel)panel).getSelectedPanel().getEnvName() + " environment" : ((sdk = panel.getSdk()) != null ? sdk.getName() : panel.getPanelName());
        String string = "Project Interpreter: " + name;
        if (string == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    private Sdk getPreferredSdk(@NotNull List<Sdk> sdks) {
        PyFrameworkProjectGenerator projectGenerator;
        if (sdks == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(13);
        }
        boolean onlyPython2 = (projectGenerator = (PyFrameworkProjectGenerator)ObjectUtils.tryCast((Object)this.getProjectGenerator(), PyFrameworkProjectGenerator.class)) != null && !projectGenerator.supportsPython3();
        Sdk preferred = (Sdk)ContainerUtil.getFirstItem(sdks);
        if (preferred == null) {
            return null;
        }
        if (onlyPython2 && !PythonSdkType.getLanguageLevelForSdk(preferred).isPython2()) {
            Sdk python2Sdk = PythonSdkType.findPython2Sdk(sdks);
            return python2Sdk != null ? python2Sdk : preferred;
        }
        return preferred;
    }

    @NotNull
    private static List<Sdk> getValidPythonSdks() {
        List list = ((StreamEx)((StreamEx)StreamEx.of(PyConfigurableInterpreterList.getInstance(null).getAllPythonSdks()).filter(sdk -> sdk != null && sdk.getSdkType() instanceof PythonSdkType && !PythonSdkType.isInvalid(sdk))).sorted((Comparator)new PreferredSdkComparator())).toList();
        if (list == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/newProject/steps/ProjectSpecificSettingsStep";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/newProject/steps/ProjectSpecificSettingsStep";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "validateFramework";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterpretersPanel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewProjectPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectInterpreterTitle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidPythonSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validateFrameworkSupportsPython3";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateFramework";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addLocationChangeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProjectInterpreterTitle";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

