/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard.move;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.ontology.wizard.move.AbstractMoveAxiomsWizardPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsKit;

public class SelectKitPanel
extends AbstractMoveAxiomsWizardPanel {
    public static final String ID = "AxiomSelectionStrategyPanel";
    public static final int DEFAULT_PREFERRED_WIDTH = 1200;
    public static final int DEFAULT_PREFERRED_HEIGHT = 800;
    private ButtonGroup bGroup;
    private JPanel holder;
    private boolean createdButtons;

    public SelectKitPanel(OWLEditorKit editorKit) {
        super(ID, "Select method", editorKit);
        this.setInstructions("Select the method of choosing axioms from the source ontology.");
    }

    public Dimension getPreferredSize() {
        return new Dimension(1200, 800);
    }

    public void aboutToDisplayPanel() {
        this.createStrategyRadioButtons();
    }

    private void createStrategyRadioButtons() {
        if (!this.createdButtons) {
            for (final MoveAxiomsKit kit : this.getWizard().getMoveAxiomsKits()) {
                JRadioButton cb = new JRadioButton(new AbstractAction(kit.getName()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SelectKitPanel.this.getWizard().setSelectedKit(kit);
                    }
                });
                cb.setOpaque(false);
                cb.setSelected(this.getWizard().getSelectedKit() == kit);
                this.bGroup.add(cb);
                this.holder.add(cb);
            }
            this.createdButtons = true;
        }
    }

    protected void createUI(JComponent parent) {
        parent.setLayout(new BorderLayout());
        this.holder = new JPanel();
        this.holder.setOpaque(false);
        this.holder.setLayout(new BoxLayout(this.holder, 3));
        this.bGroup = new ButtonGroup();
        parent.add((Component)this.holder, "North");
    }

    public Object getBackPanelDescriptor() {
        return "SelectSourceOntologiesPanel";
    }

    public Object getNextPanelDescriptor() {
        return this.getWizard().getFirstPanelIDForKit();
    }
}

