/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dialog;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang3.ArrayUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.TaskExecutionRequestEvent;
import org.pdfsam.ui.dialog.OverwriteConfirmationDialog;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.exception.BroadcastInterruptionException;
import org.sejda.injector.Auto;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.FileOrDirectoryTaskOutput;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.base.AbstractParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class OverwriteDialogController {
    private static final Logger LOG = LoggerFactory.getLogger(OverwriteDialogController.class);
    private Provider<OverwriteConfirmationDialog> dialog;

    @Inject
    public OverwriteDialogController(Provider<OverwriteConfirmationDialog> dialog) {
        this.dialog = dialog;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener(priority=-2147483648)
    public void request(TaskExecutionRequestEvent event) {
        final AbstractParameters params = event.getParameters();
        try {
            if (params.getExistingOutputPolicy() != ExistingOutputPolicy.OVERWRITE) {
                event.getParameters().getOutput().accept(new TaskOutputDispatcher(){

                    public void dispatch(FileOrDirectoryTaskOutput output) {
                        OverwriteDialogController.this.onDirectory(params, output.getDestination());
                    }

                    public void dispatch(DirectoryTaskOutput output) {
                        OverwriteDialogController.this.onDirectory(params, output.getDestination());
                    }

                    public void dispatch(FileTaskOutput output) {
                        OverwriteDialogController.this.onFile(params, output.getDestination());
                    }
                });
            }
        }
        catch (TaskOutputVisitException e) {
            LOG.warn("Unable to show overwrite confirmation dialog", (Throwable)e);
        }
    }

    private void onDirectory(AbstractParameters params, File dir) {
        if (ArrayUtils.isNotEmpty((Object[])dir.listFiles())) {
            if (!((OverwriteConfirmationDialog)((Object)this.dialog.get())).title(DefaultI18nContext.getInstance().i18n("Directory not empty")).messageTitle(DefaultI18nContext.getInstance().i18n("The selected directory is not empty")).messageContent(DefaultI18nContext.getInstance().i18n("Overwrite files with the same name as the generated ones?")).response()) {
                throw new BroadcastInterruptionException(DefaultI18nContext.getInstance().i18n("Don't overwrite existing file"));
            }
            LOG.trace("Enabling overwrite of the existing output file");
            params.setExistingOutputPolicy(ExistingOutputPolicy.OVERWRITE);
        }
    }

    private void onFile(AbstractParameters params, File file) {
        if (file.exists()) {
            if (!((OverwriteConfirmationDialog)((Object)this.dialog.get())).title(DefaultI18nContext.getInstance().i18n("Overwrite confirmation")).messageTitle(DefaultI18nContext.getInstance().i18n("A file with the given name already exists")).messageContent(DefaultI18nContext.getInstance().i18n("Do you want to overwrite it?")).response()) {
                throw new BroadcastInterruptionException(DefaultI18nContext.getInstance().i18n("Don't overwrite existing file"));
            }
            LOG.trace("Enabling overwrite of the existing output file");
            params.setExistingOutputPolicy(ExistingOutputPolicy.OVERWRITE);
        }
    }
}

