/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.utils.MaterialDesignIconFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.TransferMode;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.context.DefaultUserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.pdf.MultipleFilesDroppedEvent;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.support.EncryptionUtils;
import org.pdfsam.support.io.ObjectCollectionWriter;
import org.pdfsam.ui.commons.ClearModuleEvent;
import org.pdfsam.ui.commons.OpenFileRequest;
import org.pdfsam.ui.commons.RemoveSelectedEvent;
import org.pdfsam.ui.commons.SetDestinationRequest;
import org.pdfsam.ui.commons.SetPageRangesRequest;
import org.pdfsam.ui.commons.ShowPdfDescriptorRequest;
import org.pdfsam.ui.selection.PasswordFieldPopup;
import org.pdfsam.ui.selection.ShowPasswordFieldPopupRequest;
import org.pdfsam.ui.selection.multiple.DuplicateSelectedEvent;
import org.pdfsam.ui.selection.multiple.IndexColumn;
import org.pdfsam.ui.selection.multiple.PageRangesColumn;
import org.pdfsam.ui.selection.multiple.SelectionChangedEvent;
import org.pdfsam.ui.selection.multiple.SelectionTableRowData;
import org.pdfsam.ui.selection.multiple.TableColumnProvider;
import org.pdfsam.ui.selection.multiple.move.MoveSelectedEvent;
import org.pdfsam.ui.selection.multiple.move.MoveType;
import org.pdfsam.ui.selection.multiple.move.SelectionAndFocus;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionTable
extends TableView<SelectionTableRowData>
implements ModuleOwned,
RestorableView {
    private static final Logger LOG = LoggerFactory.getLogger(SelectionTable.class);
    private static final DataFormat DND_TABLE_SELECTION_MIME_TYPE = new DataFormat(new String[]{"application/x-java-table-selection-list"});
    private String ownerModule = "";
    private Label placeHolder = new Label(DefaultI18nContext.getInstance().i18n("Drag and drop PDF files here"));
    private PasswordFieldPopup passwordPopup;
    private Consumer<SelectionChangedEvent> selectionChangedConsumer;

    public SelectionTable(String ownerModule, boolean canDuplicateItems, boolean canMove, TableColumnProvider<?> ... columns) {
        this.ownerModule = StringUtils.defaultString((String)ownerModule);
        this.setEditable(true);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.getColumns().add((Object)new IndexColumn());
        Arrays.stream(columns).forEach(c -> this.getColumns().add(c.getTableColumn()));
        this.setColumnResizePolicy(CONSTRAINED_RESIZE_POLICY);
        this.getStyleClass().add((Object)"selection-table");
        this.initDragAndDrop(canMove);
        this.getSelectionModel().getSelectedIndices().addListener(c -> {
            ObservableList selected = c.getList();
            if (selected.isEmpty()) {
                StaticStudio.eventStudio().broadcast((Object)SelectionChangedEvent.clearSelectionEvent(), ownerModule);
                LOG.trace("Selection cleared for {}", (Object)ownerModule);
            } else {
                SelectionChangedEvent newSelectionEvent = SelectionChangedEvent.select((Collection<? extends Integer>)selected).ofTotalRows(this.getItems().size());
                StaticStudio.eventStudio().broadcast((Object)newSelectionEvent, ownerModule);
                LOG.trace("{} for {}", (Object)newSelectionEvent, (Object)ownerModule);
            }
        });
        this.placeHolder.getStyleClass().add((Object)"drag-drop-placeholder");
        this.placeHolder.setDisable(true);
        this.setPlaceholder((Node)this.placeHolder);
        this.passwordPopup = new PasswordFieldPopup(this.ownerModule);
        ContextMenu contextMenu = new ContextMenu();
        this.initTopSectionContextMenu(contextMenu, Arrays.stream(columns).anyMatch(PageRangesColumn.class::isInstance));
        this.initItemsSectionContextMenu(contextMenu, canDuplicateItems, canMove);
        this.initBottomSectionContextMenu(contextMenu);
        this.setContextMenu(contextMenu);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        StaticStudio.eventStudio().add(SelectionChangedEvent.class, e -> this.selectionChangedConsumer.accept((SelectionChangedEvent)e), ownerModule);
    }

    private void initTopSectionContextMenu(ContextMenu contextMenu, boolean hasRanges) {
        MenuItem setDestinationItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Set destination"), MaterialDesignIcon.AIRPLANE_LANDING);
        setDestinationItem.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)SetDestinationRequest.requestDestination(((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).descriptor().getFile(), this.getOwnerModule()), this.getOwnerModule()));
        setDestinationItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
        this.selectionChangedConsumer = e -> setDestinationItem.setDisable(!e.isSingleSelection());
        contextMenu.getItems().add((Object)setDestinationItem);
        if (hasRanges) {
            MenuItem setPageRangesItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Set as range for all"), MaterialDesignIcon.FORMAT_INDENT_INCREASE);
            setPageRangesItem.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new SetPageRangesRequest(((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).pageSelection.get()), this.getOwnerModule()));
            setPageRangesItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
            this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> setPageRangesItem.setDisable(!e.isSingleSelection()));
            contextMenu.getItems().add((Object)setPageRangesItem);
        }
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
    }

    private void initItemsSectionContextMenu(ContextMenu contextMenu, boolean canDuplicate, boolean canMove) {
        MenuItem removeSelected = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Remove"), MaterialDesignIcon.MINUS);
        removeSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new RemoveSelectedEvent(), this.getOwnerModule()));
        removeSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[0]));
        contextMenu.getItems().add((Object)removeSelected);
        this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> removeSelected.setDisable(e.isClearSelection()));
        if (canMove) {
            MenuItem moveTopSelected = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Move to Top"), MaterialDesignIcon.CHEVRON_DOUBLE_UP);
            moveTopSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new MoveSelectedEvent(MoveType.TOP), this.getOwnerModule()));
            MenuItem moveUpSelected = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Move Up"), MaterialDesignIcon.CHEVRON_UP);
            moveUpSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new MoveSelectedEvent(MoveType.UP), this.getOwnerModule()));
            MenuItem moveDownSelected = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Move Down"), MaterialDesignIcon.CHEVRON_DOWN);
            moveDownSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new MoveSelectedEvent(MoveType.DOWN), this.getOwnerModule()));
            MenuItem moveBottomSelected = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Move to Bottom"), MaterialDesignIcon.CHEVRON_DOUBLE_DOWN);
            moveBottomSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new MoveSelectedEvent(MoveType.BOTTOM), this.getOwnerModule()));
            contextMenu.getItems().addAll((Object[])new MenuItem[]{moveTopSelected, moveUpSelected, moveDownSelected, moveBottomSelected});
            moveBottomSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.END, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            moveDownSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DOWN, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            moveUpSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.UP, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            moveTopSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.HOME, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> {
                moveTopSelected.setDisable(!e.canMove(MoveType.TOP));
                moveUpSelected.setDisable(!e.canMove(MoveType.UP));
                moveDownSelected.setDisable(!e.canMove(MoveType.DOWN));
                moveBottomSelected.setDisable(!e.canMove(MoveType.BOTTOM));
            });
        }
        if (canDuplicate) {
            MenuItem duplicateItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Duplicate"), MaterialDesignIcon.CONTENT_DUPLICATE);
            duplicateItem.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new DuplicateSelectedEvent(), this.getOwnerModule()));
            duplicateItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT2, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            contextMenu.getItems().add((Object)duplicateItem);
            this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> duplicateItem.setDisable(e.isClearSelection()));
        }
    }

    private void initBottomSectionContextMenu(ContextMenu contextMenu) {
        MenuItem copyItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Copy to clipboard"), MaterialDesignIcon.CONTENT_COPY);
        copyItem.setOnAction(e -> this.copySelectedToClipboard());
        MenuItem infoItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Document properties"), MaterialDesignIcon.INFORMATION_OUTLINE);
        infoItem.setOnAction(e -> Platform.runLater(() -> StaticStudio.eventStudio().broadcast((Object)new ShowPdfDescriptorRequest(((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).descriptor()))));
        MenuItem openFileItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Open"), MaterialDesignIcon.FILE_PDF_BOX);
        openFileItem.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new OpenFileRequest(((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).descriptor().getFile())));
        MenuItem openFolderItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Open Folder"), MaterialDesignIcon.FOLDER_OUTLINE);
        openFolderItem.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new OpenFileRequest(((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).descriptor().getFile().getParentFile())));
        copyItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        infoItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
        openFileItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        openFolderItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.ALT_DOWN}));
        contextMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), copyItem, infoItem, openFileItem, openFolderItem});
        this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> {
            copyItem.setDisable(e.isClearSelection());
            infoItem.setDisable(!e.isSingleSelection());
            openFileItem.setDisable(!e.isSingleSelection());
            openFolderItem.setDisable(!e.isSingleSelection());
        });
    }

    private MenuItem createMenuItem(String text, MaterialDesignIcon icon) {
        MenuItem item = new MenuItem(text);
        MaterialDesignIconFactory.get().setIcon(item, (GlyphIcons)icon, "1.1em");
        item.setDisable(true);
        return item;
    }

    private void initDragAndDrop(boolean canMove) {
        this.setOnDragOver(e -> this.dragConsume((DragEvent)e, this.onDragOverConsumer()));
        this.setOnDragEntered(e -> this.dragConsume((DragEvent)e, this.onDragEnteredConsumer()));
        this.setOnDragExited(this::onDragExited);
        this.setOnDragDropped(e -> this.dragConsume((DragEvent)e, this.onDragDropped()));
        if (canMove) {
            this.setRowFactory(tv -> {
                TableRow row = new TableRow();
                row.setOnDragDetected(e -> {
                    ArrayList selection = new ArrayList(this.getSelectionModel().getSelectedIndices());
                    if (!row.isEmpty() && !selection.isEmpty()) {
                        Dragboard db = row.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                        db.setDragView((Image)row.snapshot(null, null));
                        ClipboardContent cc = new ClipboardContent();
                        cc.put((Object)DND_TABLE_SELECTION_MIME_TYPE, selection);
                        db.setContent((Map)cc);
                        e.consume();
                    }
                });
                row.setOnDragOver(e -> {
                    if (e.getGestureSource() != row && e.getDragboard().hasContent(DND_TABLE_SELECTION_MIME_TYPE) && !((List)e.getDragboard().getContent(DND_TABLE_SELECTION_MIME_TYPE)).contains(row.getIndex())) {
                        e.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                        e.consume();
                    }
                });
                row.setOnDragEntered(e -> {
                    if (!row.isEmpty() && e.getDragboard().hasContent(DND_TABLE_SELECTION_MIME_TYPE) && !((List)e.getDragboard().getContent(DND_TABLE_SELECTION_MIME_TYPE)).contains(row.getIndex())) {
                        row.setOpacity(0.6);
                    }
                });
                row.setOnDragExited(e -> {
                    if (!row.isEmpty() && e.getDragboard().hasContent(DND_TABLE_SELECTION_MIME_TYPE) && !((List)e.getDragboard().getContent(DND_TABLE_SELECTION_MIME_TYPE)).contains(row.getIndex())) {
                        row.setOpacity(1.0);
                    }
                });
                row.setOnDragDropped(e -> {
                    Dragboard db = e.getDragboard();
                    if (db.hasContent(DND_TABLE_SELECTION_MIME_TYPE)) {
                        Optional<SelectionTableRowData> focus = Optional.ofNullable((SelectionTableRowData)this.getFocusModel().getFocusedItem());
                        Optional<SelectionTableRowData> toDrop = Optional.of(row).filter(r -> !r.isEmpty()).map(IndexedCell::getIndex).map(arg_0 -> this.getItems().get(arg_0));
                        List dragged = (List)e.getDragboard().getContent(DND_TABLE_SELECTION_MIME_TYPE);
                        List toMove = dragged.stream().map(arg_0 -> this.getItems().get(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
                        this.getItems().removeAll(toMove);
                        int dropIndex = this.getItems().size();
                        if (toDrop.isPresent()) {
                            int toDropNewIndex = toDrop.map(arg_0 -> this.getItems().indexOf(arg_0)).get();
                            dropIndex = toDropNewIndex == row.getIndex() ? toDropNewIndex : toDropNewIndex + 1;
                        }
                        this.getItems().addAll(dropIndex, toMove);
                        e.setDropCompleted(true);
                        this.getSelectionModel().clearSelection();
                        this.getSelectionModel().selectRange(dropIndex, dropIndex + toMove.size());
                        focus.map(arg_0 -> this.getItems().indexOf(arg_0)).ifPresent(arg_0 -> ((TableView.TableViewFocusModel)this.getFocusModel()).focus(arg_0));
                        e.consume();
                    }
                });
                return row;
            });
        }
    }

    private void dragConsume(DragEvent e, Consumer<DragEvent> c) {
        if (e.getDragboard().hasFiles()) {
            c.accept(e);
        }
        e.consume();
    }

    private Consumer<DragEvent> onDragOverConsumer() {
        return e -> e.acceptTransferModes(TransferMode.COPY_OR_MOVE);
    }

    private Consumer<DragEvent> onDragEnteredConsumer() {
        return e -> this.placeHolder.setDisable(false);
    }

    private void onDragExited(DragEvent e) {
        this.placeHolder.setDisable(true);
        e.consume();
    }

    private Consumer<DragEvent> onDragDropped() {
        return e -> {
            StaticStudio.eventStudio().broadcast((Object)new MultipleFilesDroppedEvent(this.ownerModule, e.getDragboard().getFiles()));
            e.setDropCompleted(true);
        };
    }

    @EventStation
    public String getOwnerModule() {
        return this.ownerModule;
    }

    @EventListener(priority=-2147483648)
    public void onLoadDocumentsRequest(PdfLoadRequestEvent loadEvent) {
        this.getItems().addAll((Collection)loadEvent.getDocuments().stream().map(SelectionTableRowData::new).collect(Collectors.toList()));
        loadEvent.getDocuments().stream().findFirst().ifPresent(f -> StaticStudio.eventStudio().broadcast((Object)SetDestinationRequest.requestFallbackDestination(f.getFile(), this.getOwnerModule()), this.getOwnerModule()));
        StaticStudio.eventStudio().broadcast((Object)loadEvent);
    }

    @EventListener
    public void onDuplicate(DuplicateSelectedEvent event) {
        LOG.trace("Duplicating selected items");
        this.getSelectionModel().getSelectedItems().forEach(i -> this.getItems().add((Object)i.duplicate()));
    }

    @EventListener
    public void onClear(ClearModuleEvent event) {
        this.getItems().forEach(d -> d.descriptor().releaseAll());
        this.getSelectionModel().clearSelection();
        this.getItems().clear();
    }

    @EventListener
    public void onRemoveSelected(RemoveSelectedEvent event) {
        TreeSet<Integer> indices = new TreeSet<Integer>(Collections.reverseOrder());
        indices.addAll((Collection<Integer>)this.getSelectionModel().getSelectedIndices());
        LOG.trace("Removing {} items", (Object)indices.size());
        indices.forEach(i -> ((SelectionTableRowData)this.getItems().remove(i.intValue())).invalidate());
        this.requestFocus();
    }

    @EventListener
    public void onMoveSelected(MoveSelectedEvent event) {
        this.getSortOrder().clear();
        ObservableList selectedIndices = this.getSelectionModel().getSelectedIndices();
        Integer[] selected = (Integer[])selectedIndices.toArray((Object[])new Integer[selectedIndices.size()]);
        int focus = this.getFocusModel().getFocusedIndex();
        this.getSelectionModel().clearSelection();
        SelectionAndFocus newSelection = event.getType().move(selected, this.getItems(), focus);
        if (!SelectionAndFocus.NULL.equals(newSelection)) {
            LOG.trace("Changing selection to {}", (Object)newSelection);
            this.getSelectionModel().selectIndices(newSelection.getRow(), newSelection.getRows());
            this.getFocusModel().focus(newSelection.getFocus());
            this.scrollTo(newSelection.getFocus());
        }
    }

    @EventListener
    public void onSetPageRanges(SetPageRangesRequest event) {
        this.getItems().stream().forEach(i -> i.pageSelection.set(event.range));
    }

    @EventListener
    public void showPasswordFieldPopup(ShowPasswordFieldPopupRequest request) {
        Window owner;
        Scene scene = this.getScene();
        if (scene != null && (owner = scene.getWindow()) != null && owner.isShowing()) {
            Point2D nodeCoord = request.getRequestingNode().localToScene(request.getRequestingNode().getWidth() / 2.0, request.getRequestingNode().getHeight() / 1.5);
            double anchorX = Math.round(owner.getX() + scene.getX() + nodeCoord.getX() + 2.0);
            double anchorY = Math.round(owner.getY() + scene.getY() + nodeCoord.getY() + 2.0);
            this.passwordPopup.showFor((Node)this, request.getPdfDescriptor(), anchorX, anchorY);
        }
    }

    private void copySelectedToClipboard() {
        ClipboardContent content = new ClipboardContent();
        ObjectCollectionWriter.writeContent((Collection)this.getSelectionModel().getSelectedItems().stream().map(item -> item.descriptor().getFile().getAbsolutePath() + ", " + item.descriptor().getFile().length() + ", " + item.descriptor().pages().getValue()).collect(Collectors.toList())).to(content);
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public void saveStateTo(Map<String, String> data) {
        data.put(StringUtils.defaultString((String)this.getId()) + "input.size", Integer.toString(this.getItems().size()));
        IntStream.range(0, this.getItems().size()).forEach(i -> {
            SelectionTableRowData current = (SelectionTableRowData)this.getItems().get(i);
            String id = StringUtils.defaultString((String)this.getId());
            data.put(id + "input." + i, current.descriptor().getFile().getAbsolutePath());
            if (new DefaultUserContext().isSavePwdInWorkspaceFile()) {
                data.put(id + "input.password.enc" + i, EncryptionUtils.encrypt((String)current.descriptor().getPassword()));
            }
            data.put(id + "input.range." + i, StringUtils.defaultString((String)current.pageSelection.get()));
            data.put(id + "input.step." + i, StringUtils.defaultString((String)current.pace.get()));
            data.put(id + "input.reverse." + i, Boolean.toString(current.reverse.get()));
        });
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.onClear(null);
        int size = Optional.ofNullable(data.get(StringUtils.defaultString((String)this.getId()) + "input.size")).map(Integer::valueOf).orElse(0);
        if (size > 0) {
            PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(this.getOwnerModule());
            ArrayList items = new ArrayList();
            IntStream.range(0, size).forEach(i -> {
                String id = StringUtils.defaultString((String)this.getId());
                Optional.ofNullable((String)data.get(id + "input." + i)).ifPresent(f -> {
                    PdfDocumentDescriptor descriptor = PdfDocumentDescriptor.newDescriptor((File)new File((String)f), (String)Optional.ofNullable((String)data.get(id + "input.password.enc" + i)).map(EncryptionUtils::decrypt).orElseGet(() -> (String)data.get(StringUtils.defaultString((String)this.getId()) + "input.password." + i)));
                    loadEvent.add(descriptor);
                    SelectionTableRowData row = new SelectionTableRowData(descriptor);
                    row.pageSelection.set((String)data.get(id + "input.range." + i));
                    row.pace.set((String)data.get(id + "input.step." + i));
                    row.reverse.set(Boolean.valueOf((String)data.get(id + "input.reverse." + i)).booleanValue());
                    items.add(row);
                });
            });
            this.getItems().addAll(items);
            StaticStudio.eventStudio().broadcast((Object)loadEvent);
        }
    }
}

