# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object import DataObject


class Selection(DataObject):
    """
    Selection - data object that represents a "selection" in VTK.
    
    Superclass: DataObject
    
    Selection is a data object that represents a selection definition.
    It is used to define the elements that are selected. The criteria of
    the selection is defined using one or more SelectionNode
    instances. Parameters of the SelectionNode define what kind of
    elements are being selected (vtk_selection_node::_get_field_type), how the
    selection criteria is defined (vtk_selection_node::_get_content_type),
    etc.
    
    Filters like ExtractSelection, ExtractDataArraysOverTime can be
    used to extract the selected elements from a dataset.
    
    @section combining_selection Combining Selections
    
    When a Selection contains multiple SelectionNode instances, the
    selection defined is a union of all the elements identified by each
    of the nodes.
    
    Optionally, one can use `vtk_selection::_set_expression` to define a
    boolean expression to build arbitrarily complex combinations. The
    expression can be defined using names assigned to the selection nodes
    when the nodes are added to Selection (either explicitly or
    automatically).
    
    @sa
    SelectionNode
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSelection, obj, update, **traits)
    
    expression = traits.String('', enter_set=True, auto_set=False, desc=\
        """
        Get/Set the expression that defines the boolean expression to
        combine the selection nodes. Expression consists of node name
        identifiers, `|` for boolean-or, '&' for boolean and, '!' for
        boolean not, and parenthesis `(` and `)`. If the expression
        consists of a node name identifier that is not assigned any
        `vtk_selection_node` (using `_set_node`) then it is evaluates to
        `false`.
        
        `_set_expression` does not validate the expression. It will be
        validated in `Evaluate` call.
        """
    )

    def _expression_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExpression,
                        self.expression)

    def get_node(self, *args):
        """
        V.get_node(int) -> SelectionNode
        C++: virtual SelectionNode *GetNode(unsigned int idx)
        V.get_node(string) -> SelectionNode
        C++: virtual SelectionNode *GetNode(const std::string &name)
        Returns a node given it's index. Performs bound checking and will
        return nullptr if out-of-bounds.
        """
        ret = self._wrap_call(self._vtk_obj.GetNode, *args)
        return wrap_vtk(ret)

    def set_node(self, *args):
        """
        V.set_node(string, SelectionNode)
        C++: virtual void SetNode(const std::string &name,
            SelectionNode *)
        Adds a SelectionNode and assigns it the specified name. The
        name must be a non-empty string. If an item with the same name
        has already been added, it will be removed.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetNode, *my_args)
        return ret

    def get_node_name_at_index(self, *args):
        """
        V.get_node_name_at_index(int) -> string
        C++: virtual std::string GetNodeNameAtIndex(unsigned int idx)
        Returns the name for a node at the given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetNodeNameAtIndex, *args)
        return ret

    def _get_number_of_nodes(self):
        return self._vtk_obj.GetNumberOfNodes()
    number_of_nodes = traits.Property(_get_number_of_nodes, desc=\
        """
        Returns the number of nodes in this selection. Each node contains
        information about part of the selection.
        """
    )

    def add_node(self, *args):
        """
        V.add_node(SelectionNode) -> string
        C++: virtual std::string AddNode(SelectionNode *)
        Adds a selection node. Assigns the node a unique name and returns
        that name. This API is primarily provided for backwards
        compatibility and `_set_node` is the preferred method.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddNode, *my_args)
        return ret

    def dump(self):
        """
        V.dump()
        C++: virtual void Dump()
        Dumps the contents of the selection, giving basic information
        only.
        """
        ret = self._vtk_obj.Dump()
        return ret
        

    def remove_all_nodes(self):
        """
        V.remove_all_nodes()
        C++: virtual void RemoveAllNodes()
        Removes all selection nodes.
        """
        ret = self._vtk_obj.RemoveAllNodes()
        return ret
        

    def remove_node(self, *args):
        """
        V.remove_node(int)
        C++: virtual void RemoveNode(unsigned int idx)
        V.remove_node(string)
        C++: virtual void RemoveNode(const std::string &name)
        V.remove_node(SelectionNode)
        C++: virtual void RemoveNode(SelectionNode *)
        Removes a selection node.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveNode, *my_args)
        return ret

    def subtract(self, *args):
        """
        V.subtract(Selection)
        C++: virtual void Subtract(Selection *selection)
        V.subtract(SelectionNode)
        C++: virtual void Subtract(SelectionNode *node)
        Remove the nodes from the specified selection from this
        selection. Assumes that selection node internal arrays are
        IdTypeArrays.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Subtract, *my_args)
        return ret

    def union(self, *args):
        """
        V.union(Selection)
        C++: virtual void Union(Selection *selection)
        V.union(SelectionNode)
        C++: virtual void Union(SelectionNode *node)
        Union this selection with the specified selection. Attempts to
        reuse selection nodes in this selection if properties match
        exactly. Otherwise, creates new selection nodes.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Union, *my_args)
        return ret

    _updateable_traits_ = \
    (('global_release_data_flag', 'GetGlobalReleaseDataFlag'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('expression', 'GetExpression'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display',
    'expression'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Selection, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Selection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_release_data_flag'], [], ['expression']),
            title='Edit Selection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Selection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

