/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.DoubleDoubleHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class DoubleDoubleScatterMap
extends DoubleDoubleHashMap {
    public DoubleDoubleScatterMap() {
        this(4);
    }

    public DoubleDoubleScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public DoubleDoubleScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(double key) {
        return BitMixer.mixPhi(key);
    }

    public static DoubleDoubleScatterMap from(double[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleDoubleScatterMap map = new DoubleDoubleScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

