/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCodegenUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceDelegationLoweringKt;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001$B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0016J\f\u0010#\u001a\u00020\u0018*\u00020\u0012H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceDelegationLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "replacementMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getReplacementMap", "()Ljava/util/Map;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "getState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "generateDelegationToDefaultImpl", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "interfaceFun", "inheritedFun", "isDefaultImplsGeneration", "", "generateInterfaceMethods", "", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitClass", "declaration", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "hasInterfaceParent", "OverriddenSymbolsReplacer", "backend.jvm"})
final class InterfaceDelegationLowering
implements FileLoweringPass,
IrElementVisitorVoid {
    @NotNull
    private final GenerationState state;
    @NotNull
    private final Map<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> replacementMap;
    @NotNull
    private final JvmBackendContext context;

    @NotNull
    public final GenerationState getState() {
        return this.state;
    }

    @NotNull
    public final Map<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> getReplacementMap() {
        return this.replacementMap;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        IrElementVisitorVoidKt.acceptChildrenVoid(irFile, this);
        IrElementVisitorVoidKt.acceptVoid(irFile, new OverriddenSymbolsReplacer(this.replacementMap));
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
        if (IrCodegenUtilsKt.isJvmInterface(declaration2)) {
            return;
        }
        this.generateInterfaceMethods(declaration2);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateInterfaceMethods(IrClass irClass) {
        void actualClass;
        Pair<IrClass, Boolean> pair;
        if (Intrinsics.areEqual(irClass.getOrigin(), JvmLoweredDeclarationOrigin.DEFAULT_IMPLS.INSTANCE)) {
            IrDeclarationParent irDeclarationParent = irClass.getParent();
            if (irDeclarationParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            }
            pair = new Pair<IrClass, Boolean>((IrClass)irDeclarationParent, true);
        } else {
            pair = new Pair<IrClass, Boolean>(irClass, false);
        }
        Pair<IrClass, Boolean> pair2 = pair;
        IrClass irClass2 = (IrClass)pair2.component1();
        boolean isDefaultImplsGeneration = pair2.component2();
        boolean bl = false;
        List toRemove = new ArrayList();
        for (IrSimpleFunction function2 : SequencesKt.toList(IrUtilsKt.getFunctions((IrClass)actualClass))) {
            IrSimpleFunction implementation;
            if (function2.getOrigin() != IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) continue;
            if (!isDefaultImplsGeneration) {
                boolean bl2;
                block9: {
                    Iterable $this$any$iv = function2.getOverriddenSymbols();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                            boolean bl3 = false;
                            if (!((!IrUtilsKt.isInterface(IrUtilsKt.getParentAsClass((IrDeclaration)it.getOwner())) || org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.hasJvmDefault(it.getOwner())) && ((IrSimpleFunction)it.getOwner()).getModality() != Modality.ABSTRACT)) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) continue;
            }
            if (IrUtilsKt.resolveFakeOverride(function2) == null) {
                continue;
            }
            if (!this.hasInterfaceParent(implementation) || Visibilities.isPrivate(implementation.getVisibility()) || InterfaceDelegationLoweringKt.access$isDefinitelyNotDefaultImplsMethod(implementation) || org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isMethodOfAny(implementation)) continue;
            IrSimpleFunction delegation = this.generateDelegationToDefaultImpl(irClass, implementation, function2, isDefaultImplsGeneration);
            if (isDefaultImplsGeneration) continue;
            toRemove.add(function2);
            this.replacementMap.put((IrSimpleFunctionSymbol)function2.getSymbol(), (IrSimpleFunctionSymbol)delegation.getSymbol());
        }
        irClass.getDeclarations().removeAll(toRemove);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateDelegationToDefaultImpl(IrClass irClass, IrSimpleFunction interfaceFun, IrSimpleFunction inheritedFun, boolean isDefaultImplsGeneration) {
        void $this$mapIndexedTo$iv$iv;
        int n;
        IrValueParameter it;
        boolean bl;
        boolean bl2;
        IrValueParameter irValueParameter;
        void $this$irBlockBody$iv;
        IrSimpleFunction irSimpleFunction;
        Object $this$apply;
        IrSimpleFunction defaultImplFun = this.context.getDeclarationFactory().getDefaultImplsFunction(interfaceFun);
        if (!isDefaultImplsGeneration) {
            Annotations annotations2 = inheritedFun.getDescriptor().getAnnotations();
            SourceElement sourceElement = inheritedFun.getDescriptor().getSource();
            Intrinsics.checkExpressionValueIsNotNull(sourceElement, "inheritedFun.descriptor.source");
            WrappedSimpleFunctionDescriptor descriptor2 = new WrappedSimpleFunctionDescriptor(annotations2, sourceElement);
            Name name = Name.identifier(this.context.getState().getTypeMapper().mapFunctionName(inheritedFun.getDescriptor(), OwnerKind.IMPLEMENTATION));
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(context.\u2026wnerKind.IMPLEMENTATION))");
            Name name2 = name;
            IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = new IrSimpleFunctionSymbolImpl(descriptor2);
            Visibility visibility = Visibilities.PUBLIC;
            Intrinsics.checkExpressionValueIsNotNull(visibility, "Visibilities.PUBLIC");
            IrFunctionImpl irFunctionImpl = new IrFunctionImpl(-1, -1, irDeclarationOrigin, irSimpleFunctionSymbol, name2, visibility, inheritedFun.getModality(), inheritedFun.getReturnType(), inheritedFun.isInline(), false, false, inheritedFun.isSuspend());
            boolean bl3 = false;
            boolean bl4 = false;
            $this$apply = irFunctionImpl;
            boolean bl5 = false;
            descriptor2.bind((IrDeclaration)$this$apply);
            ((IrDeclarationBase)$this$apply).setParent(inheritedFun.getParent());
            ((IrFunctionImpl)$this$apply).getOverriddenSymbols().addAll(inheritedFun.getOverriddenSymbols());
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyParameterDeclarationsFrom((IrFunction)$this$apply, inheritedFun);
            ((IrDeclarationBase)$this$apply).getAnnotations().addAll((Collection<IrConstructorCall>)inheritedFun.getAnnotations());
            irSimpleFunction = irFunctionImpl;
        } else {
            irSimpleFunction = this.context.getDeclarationFactory().getDefaultImplsFunction(inheritedFun);
        }
        IrSimpleFunction irFunction = irSimpleFunction;
        irClass.getDeclarations().add(irFunction);
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, irFunction.getSymbol(), -1, -1);
        boolean bl6 = false;
        boolean bl7 = false;
        DeclarationIrBuilder $this$apply2 = declarationIrBuilder;
        boolean bl8 = false;
        $this$apply = $this$apply2;
        IrSimpleFunction irSimpleFunction2 = irFunction;
        int startOffset$iv = $this$irBlockBody$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder this_$iv$iv = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        IrBlockBodyBuilder $this$irBlockBody = this_$iv$iv;
        boolean bl9 = false;
        IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irBlockBody, (IrSimpleFunctionSymbol)defaultImplFun.getSymbol(), irFunction.getReturnType());
        IrBuilderWithScope irBuilderWithScope = $this$irBlockBody;
        IrBlockBodyBuilder irBlockBodyBuilder = $this$irBlockBody;
        boolean bl10 = false;
        boolean bl11 = false;
        IrCall $this$apply3 = irCall;
        boolean bl12 = false;
        int offset2 = 0;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.passTypeArgumentsFrom$default($this$apply3, irFunction, 0, 2, null);
        IrValueParameter irValueParameter2 = irFunction.getDispatchReceiverParameter();
        if (irValueParameter2 != null) {
            irValueParameter = irValueParameter2;
            bl2 = false;
            bl = false;
            it = irValueParameter;
            boolean bl13 = false;
            n = offset2;
            offset2 = n + 1;
            $this$apply3.putValueArgument(n, ExpressionHelpersKt.irGet($this$irBlockBody, it));
        }
        IrValueParameter irValueParameter3 = irFunction.getExtensionReceiverParameter();
        if (irValueParameter3 != null) {
            irValueParameter = irValueParameter3;
            bl2 = false;
            bl = false;
            it = irValueParameter;
            boolean bl14 = false;
            n = offset2;
            offset2 = n + 1;
            $this$apply3.putValueArgument(n, ExpressionHelpersKt.irGet($this$irBlockBody, it));
        }
        Iterable $this$mapIndexed$iv = irFunction.getValueParameters();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void parameter;
            void i;
            int n2 = index$iv$iv++;
            Collection collection = destination$iv$iv;
            boolean bl15 = false;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n3 = n2;
            IrValueParameter irValueParameter4 = (IrValueParameter)item$iv$iv;
            int n4 = n3;
            Collection collection2 = collection;
            boolean bl16 = false;
            $this$apply3.putValueArgument((int)(i + offset2), ExpressionHelpersKt.irGet($this$irBlockBody, (IrValueDeclaration)parameter));
            Unit unit = Unit.INSTANCE;
            collection2.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        IrCall irCall2 = irCall;
        irBlockBodyBuilder.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irCall2));
        IrBlockBody irBlockBody2 = this_$iv$iv.doBuild();
        irSimpleFunction2.setBody(irBlockBody2);
        return irFunction;
    }

    private final boolean hasInterfaceParent(@NotNull IrSimpleFunction $this$hasInterfaceParent) {
        IrDeclarationParent irDeclarationParent = $this$hasInterfaceParent.getParent();
        if (!(irDeclarationParent instanceof IrClass)) {
            irDeclarationParent = null;
        }
        IrClass irClass = (IrClass)irDeclarationParent;
        return irClass != null && IrUtilsKt.isInterface(irClass);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public InterfaceDelegationLowering(@NotNull JvmBackendContext context2) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(context2, "context");
        this.context = context2;
        this.state = this.context.getState();
        InterfaceDelegationLowering interfaceDelegationLowering = this;
        boolean bl = false;
        interfaceDelegationLowering.replacementMap = map2 = (Map)new LinkedHashMap();
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body, data);
    }

    @Override
    public void visitBody(@NotNull IrBody body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body);
    }

    @Override
    public void visitBody(@NotNull IrBody body, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body, data);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        Intrinsics.checkParameterIsNotNull(branch, "branch");
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(branch, "branch");
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        Intrinsics.checkParameterIsNotNull(jump, "jump");
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(jump, "jump");
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        Intrinsics.checkParameterIsNotNull(jump, "jump");
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(jump, "jump");
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        Intrinsics.checkParameterIsNotNull(aCatch, "aCatch");
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(aCatch, "aCatch");
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        Intrinsics.checkParameterIsNotNull(jump, "jump");
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(jump, "jump");
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclaration declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
        Intrinsics.checkParameterIsNotNull(loop2, "loop");
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(loop2, "loop");
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        Intrinsics.checkParameterIsNotNull(branch, "branch");
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(branch, "branch");
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body, data);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
    }

    @Override
    public void visitField(@NotNull IrField declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
    }

    @Override
    public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2) {
        Intrinsics.checkParameterIsNotNull(loop2, "loop");
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(loop2, "loop");
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
    }

    @Override
    public void visitSetVariable(@NotNull IrSetVariable expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
    }

    @Override
    public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        Intrinsics.checkParameterIsNotNull(spread, "spread");
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(spread, "spread");
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body, data);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        Intrinsics.checkParameterIsNotNull(aTry, "aTry");
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(aTry, "aTry");
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
    }

    @Override
    public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
        Intrinsics.checkParameterIsNotNull(loop2, "loop");
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(loop2, "loop");
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceDelegationLowering$OverriddenSymbolsReplacer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "replacementMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "(Ljava/util/Map;)V", "getReplacementMap", "()Ljava/util/Map;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitSimpleFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backend.jvm"})
    private static final class OverriddenSymbolsReplacer
    implements IrElementVisitorVoid {
        @NotNull
        private final Map<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> replacementMap;

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            declaration2.getOverriddenSymbols().replaceAll((UnaryOperator)new UnaryOperator<IrSimpleFunctionSymbol>(this){
                final /* synthetic */ OverriddenSymbolsReplacer this$0;

                @NotNull
                public final IrSimpleFunctionSymbol apply(@NotNull IrSimpleFunctionSymbol symbol2) {
                    Intrinsics.checkParameterIsNotNull(symbol2, "symbol");
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.this$0.getReplacementMap().get(symbol2);
                    if (irSimpleFunctionSymbol == null) {
                        irSimpleFunctionSymbol = symbol2;
                    }
                    return irSimpleFunctionSymbol;
                }
                {
                    this.this$0 = overriddenSymbolsReplacer;
                }
            });
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
        }

        @NotNull
        public final Map<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> getReplacementMap() {
            return this.replacementMap;
        }

        public OverriddenSymbolsReplacer(@NotNull Map<IrSimpleFunctionSymbol, ? extends IrSimpleFunctionSymbol> replacementMap) {
            Intrinsics.checkParameterIsNotNull(replacementMap, "replacementMap");
            this.replacementMap = replacementMap;
        }

        @Override
        public void visitElement(@NotNull IrElement element, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body);
        }

        @Override
        public void visitBody(@NotNull IrBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch) {
            Intrinsics.checkParameterIsNotNull(branch, "branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(branch, "branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            Intrinsics.checkParameterIsNotNull(aCatch, "aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(aCatch, "aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
            Intrinsics.checkParameterIsNotNull(loop2, "loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(loop2, "loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch) {
            Intrinsics.checkParameterIsNotNull(branch, "branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(branch, "branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
        }

        @Override
        public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2) {
            Intrinsics.checkParameterIsNotNull(loop2, "loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(loop2, "loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            Intrinsics.checkParameterIsNotNull(spread, "spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(spread, "spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry) {
            Intrinsics.checkParameterIsNotNull(aTry, "aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(aTry, "aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
        }

        @Override
        public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
            Intrinsics.checkParameterIsNotNull(loop2, "loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(loop2, "loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }
}

