/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.DoubleAttribute;
import org.jboss.security.xacml.sunxacml.attr.IntegerAttribute;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.cond.FunctionBase;

public class SubtractFunction
extends FunctionBase {
    public static final String NAME_INTEGER_SUBTRACT = "urn:oasis:names:tc:xacml:1.0:function:integer-subtract";
    public static final String NAME_DOUBLE_SUBTRACT = "urn:oasis:names:tc:xacml:1.0:function:double-subtract";
    private static final int ID_INTEGER_SUBTRACT = 0;
    private static final int ID_DOUBLE_SUBTRACT = 1;

    public SubtractFunction(String functionName) {
        super(functionName, SubtractFunction.getId(functionName), SubtractFunction.getArgumentType(functionName), false, 2, SubtractFunction.getArgumentType(functionName), false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_INTEGER_SUBTRACT)) {
            return 0;
        }
        if (functionName.equals(NAME_DOUBLE_SUBTRACT)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown subtract function " + functionName);
    }

    private static String getArgumentType(String functionName) {
        if (functionName.equals(NAME_INTEGER_SUBTRACT)) {
            return "http://www.w3.org/2001/XMLSchema#integer";
        }
        return "http://www.w3.org/2001/XMLSchema#double";
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_INTEGER_SUBTRACT);
        set.add(NAME_DOUBLE_SUBTRACT);
        return set;
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        switch (this.getFunctionId()) {
            case 0: {
                long arg0 = ((IntegerAttribute)argValues[0]).getValue();
                long arg1 = ((IntegerAttribute)argValues[1]).getValue();
                long difference = arg0 - arg1;
                result = new EvaluationResult(new IntegerAttribute(difference));
                break;
            }
            case 1: {
                double arg0 = ((DoubleAttribute)argValues[0]).getValue();
                double arg1 = ((DoubleAttribute)argValues[1]).getValue();
                double difference = arg0 - arg1;
                result = new EvaluationResult(new DoubleAttribute(difference));
                break;
            }
        }
        return result;
    }
}

